/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionCompatibilityTarget;
import org.eclipse.sapphire.VersionCompatibilityTargetService;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DeclarativeVersionCompatibilityTargetService
extends VersionCompatibilityTargetService {
    private FunctionResult versionFunctionResult;
    private FunctionResult versionedFunctionResult;

    @Override
    protected void initContextVersionService() {
        Element element = this.context(Element.class);
        PropertyDef property = this.context(PropertyDef.class);
        VersionCompatibilityTarget versionCompatibilityTargetAnnotation = property != null ? property.getAnnotation(VersionCompatibilityTarget.class) : element.type().getAnnotation(VersionCompatibilityTarget.class);
        Function versionFunction = null;
        try {
            versionFunction = ExpressionLanguageParser.parse(versionCompatibilityTargetAnnotation.version());
        }
        catch (Exception e) {
            Sapphire.service(LoggingService.class).log(e);
        }
        if (versionFunction == null) {
            versionFunction = Literal.NULL;
            this.versionedFunctionResult = versionFunction.evaluate(new FunctionContext());
        } else {
            versionFunction = FailSafeFunction.create(versionFunction, Literal.create(Version.class), null);
            this.versionFunctionResult = versionFunction.evaluate(new ModelElementFunctionContext(element));
            this.versionFunctionResult.attach(new Listener(){

                @Override
                public void handle(Event event) {
                    DeclarativeVersionCompatibilityTargetService.this.refresh();
                }
            });
        }
        Function versionedFunction = null;
        try {
            versionedFunction = ExpressionLanguageParser.parse(versionCompatibilityTargetAnnotation.versioned());
        }
        catch (Exception e) {
            Sapphire.service(LoggingService.class).log(e);
        }
        if (versionedFunction == null) {
            versionedFunction = Literal.NULL;
            this.versionedFunctionResult = versionedFunction.evaluate(new FunctionContext());
        } else {
            versionedFunction = FailSafeFunction.create(versionedFunction, Literal.create(String.class), null);
            this.versionedFunctionResult = versionedFunction.evaluate(new ModelElementFunctionContext(element));
            this.versionedFunctionResult.attach(new Listener(){

                @Override
                public void handle(Event event) {
                    DeclarativeVersionCompatibilityTargetService.this.refresh();
                }
            });
        }
    }

    @Override
    protected VersionCompatibilityTargetService.Data compute() {
        return new VersionCompatibilityTargetService.Data((Version)this.versionFunctionResult.value(), (String)this.versionedFunctionResult.value());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.versionFunctionResult != null) {
            try {
                this.versionFunctionResult.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
        if (this.versionFunctionResult != null) {
            try {
                this.versionFunctionResult.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef property = context.find(PropertyDef.class);
            if (property != null) {
                return property.hasAnnotation(VersionCompatibilityTarget.class);
            }
            Element element = context.find(Element.class);
            return element != null && element.type().hasAnnotation(VersionCompatibilityTarget.class);
        }
    }
}

