/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.el.DeferredFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;
import org.eclipse.sapphire.util.CollectionsUtil;

public class FunctionContext {
    @Text(value="Property \"{0}\" is undefined.")
    private static LocalizableText undefinedPropertyMessage;
    @Text(value="Property \"{0}\" is undefined for {1} objects.")
    private static LocalizableText undefinedPropertyMessageExt;
    @Text(value="Cannot read properties from null object.")
    private static LocalizableText cannotReadPropertiesFromNull;
    @Text(value="Index {0} is outside the bounds of the collection.")
    private static LocalizableText indexOutOfBounds;

    static {
        LocalizableText.init(FunctionContext.class);
    }

    public FunctionResult property(final Object element, final String name) {
        DeferredFunction f;
        if (element == null) {
            throw new FunctionException(cannotReadPropertiesFromNull.text());
        }
        if (element instanceof Map) {
            Map map;
            Object value;
            if (!name.equalsIgnoreCase("Size") && (value = CollectionsUtil.findIgnoringCase(map = (Map)element, name)) != null) {
                Function f2 = new Function(){

                    @Override
                    public String name() {
                        return name;
                    }

                    @Override
                    public FunctionResult evaluate(FunctionContext context) {
                        return new FunctionResult(this, context){

                            @Override
                            protected Object evaluate() {
                                return value;
                            }
                        };
                    }
                };
                f2.init(new Function[0]);
                return f2.evaluate(this);
            }
        } else {
            try {
                final int index = Integer.parseInt(name);
                if (element instanceof List) {
                    final List list = (List)element;
                    Function f3 = new Function(){

                        @Override
                        public String name() {
                            return name;
                        }

                        @Override
                        public FunctionResult evaluate(FunctionContext context) {
                            return new FunctionResult(this, context){

                                @Override
                                protected Object evaluate() {
                                    if (index >= 0 && index < list.size()) {
                                        return list.get(index);
                                    }
                                    throw new FunctionException(indexOutOfBounds.format(index));
                                }
                            };
                        }
                    };
                    f3.init(new Function[0]);
                    return f3.evaluate(this);
                }
                if (element.getClass().isArray()) {
                    Function f4 = new Function(){

                        @Override
                        public String name() {
                            return name;
                        }

                        @Override
                        public FunctionResult evaluate(FunctionContext context) {
                            return new FunctionResult(this, context){

                                @Override
                                protected Object evaluate() {
                                    if (index >= 0 && index < Array.getLength(element)) {
                                        return Array.get(element, index);
                                    }
                                    throw new FunctionException(indexOutOfBounds.format(index));
                                }
                            };
                        }
                    };
                    f4.init(new Function[0]);
                    return f4.evaluate(this);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (element == this) {
            if (!SapphireModelingExtensionSystem.functions(name, 0).isEmpty()) {
                f = new DeferredFunction(name);
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
        } else if (!SapphireModelingExtensionSystem.functions(name, 1).isEmpty()) {
            f = new DeferredFunction(name);
            f.init(Literal.create(element));
            return ((Function)f).evaluate(this);
        }
        if (element == this) {
            throw new FunctionException(undefinedPropertyMessage.format(name));
        }
        Class<?> cl = element.getClass();
        String type = cl.isArray() ? String.valueOf(cl.getComponentType().getName()) + "[]" : cl.getName();
        throw new FunctionException(undefinedPropertyMessageExt.format(name, type));
    }

    public LocalizationService getLocalizationService() {
        return SourceLanguageLocalizationService.INSTANCE;
    }
}

