/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.util.Comparators;
import org.eclipse.sapphire.util.Filters;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.sapphire.util.SortedSetFactory;

public abstract class PossibleValuesService
extends Service {
    @Text(value="\"{0}\" is not among possible values")
    private static LocalizableText defaultInvalidValueMessage;
    private final String invalidValueMessageTemplate;
    private final Status.Severity invalidValueSeverity;
    private final boolean caseSensitive;
    private final boolean ordered;

    static {
        LocalizableText.init(PossibleValuesService.class);
    }

    public PossibleValuesService(String invalidValueMessageTemplate, Status.Severity invalidValueSeverity, boolean caseSensitive, boolean ordered) {
        this.invalidValueMessageTemplate = invalidValueMessageTemplate == null || invalidValueMessageTemplate.length() == 0 ? defaultInvalidValueMessage.text() : invalidValueMessageTemplate;
        this.invalidValueSeverity = invalidValueSeverity == null ? Status.Severity.ERROR : invalidValueSeverity;
        this.caseSensitive = caseSensitive;
        this.ordered = ordered;
    }

    public PossibleValuesService() {
        this(null, null, true, false);
    }

    public final Set<String> values() {
        if (this.ordered()) {
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            this.fillPossibleValues(values);
            return SetFactory.start().filter(Filters.createNotEmptyFilter()).add((Collection<String>)values).result();
        }
        Comparator<String> comparator = this.isCaseSensitive() ? null : Comparators.createIgnoreCaseComparator();
        TreeSet<String> values = new TreeSet<String>(comparator);
        this.fillPossibleValues(values);
        return SortedSetFactory.start(comparator).filter(Filters.createNotEmptyFilter()).add((Collection<String>)values).result();
    }

    protected abstract void fillPossibleValues(Set<String> var1);

    public String getInvalidValueMessage(String invalidValue) {
        return MessageFormat.format(this.invalidValueMessageTemplate, invalidValue, this.context(PropertyDef.class).getLabel(true, CapitalizationType.NO_CAPS, false));
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return this.invalidValueSeverity;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean ordered() {
        return this.ordered;
    }
}

