/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address.internal;

import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.samples.zipcodes.ZipCodeRepository;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class StatePossibleValuesService
extends PossibleValuesService {
    protected void init() {
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                StatePossibleValuesService.this.broadcast();
            }
        };
        Address address = (Address)this.context(Address.class);
        address.getCity().attach((Listener)listener);
        address.getZipCode().attach((Listener)listener);
    }

    protected void fillPossibleValues(Set<String> values) {
        Address address = (Address)this.context(Address.class);
        String city = address.getCity().text();
        String zip = address.getZipCode().text();
        values.addAll(ZipCodeRepository.getStateCodes(zip, city));
    }

    public String getInvalidValueMessage(String invalidValue) {
        return NLS.bind((String)"\"{0}\" is not a valid state postal code for the specified city and ZIP code.", (Object)invalidValue);
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

