/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.sapphire.CollationService;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.DataService;
import org.eclipse.sapphire.util.Filters;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.sapphire.util.SortedSetFactory;

public abstract class PossibleValuesService
extends DataService<Set<String>> {
    @Text(value="\"{0}\" is not among possible values")
    private static LocalizableText defaultInvalidValueMessage;
    protected String invalidValueMessage;
    protected Function invalidValueMessageFunction;
    protected Status.Severity invalidValueSeverity = Status.Severity.ERROR;
    protected boolean ordered = false;
    private CollationService collationService;
    private Listener collationServiceListener;

    static {
        LocalizableText.init(PossibleValuesService.class);
    }

    @Override
    protected final void initDataService() {
        this.collationService = this.service(CollationService.class);
        this.collationServiceListener = new Listener(){

            @Override
            public void handle(Event event) {
                PossibleValuesService.this.refresh();
            }
        };
        this.collationService.attach(this.collationServiceListener);
        this.initPossibleValuesService();
    }

    protected void initPossibleValuesService() {
    }

    public final Set<String> values() {
        return (Set)this.data();
    }

    @Override
    protected final Set<String> compute() {
        if (this.ordered()) {
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            this.compute(values);
            return SetFactory.start().filter(Filters.createNotEmptyFilter()).add((Collection<String>)values).result();
        }
        Comparator<String> comparator = this.collationService.comparator();
        TreeSet<String> values = new TreeSet<String>(comparator);
        this.compute(values);
        return SortedSetFactory.start(comparator).filter(Filters.createNotEmptyFilter()).add((Collection<String>)values).result();
    }

    protected abstract void compute(Set<String> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status problem(Value<?> value) {
        if (this.invalidValueSeverity != Status.Severity.OK) {
            Object object = this;
            synchronized (object) {
                if (this.invalidValueMessageFunction == null) {
                    String def = MessageFormat.format(defaultInvalidValueMessage.text(), "${" + value.name() + "}");
                    if (this.invalidValueMessage == null) {
                        this.invalidValueMessage = def;
                    }
                    this.invalidValueMessageFunction = FailSafeFunction.create(ExpressionLanguageParser.parse(this.invalidValueMessage), String.class, def);
                }
            }
            object = null;
            Object var3_4 = null;
            try (FunctionResult messageFunctionResult = this.invalidValueMessageFunction.evaluate(new ModelElementFunctionContext(value.element()));){
                return Status.createStatus(this.invalidValueSeverity, (String)messageFunctionResult.value());
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        return Status.createOkStatus();
    }

    public boolean ordered() {
        return this.ordered;
    }

    public boolean strict() {
        return this.invalidValueSeverity == Status.Severity.ERROR;
    }

    @Override
    public void dispose() {
        if (this.collationService != null) {
            this.collationService.detach(this.collationServiceListener);
            this.collationService = null;
            this.collationServiceListener = null;
        }
        super.dispose();
    }
}

