/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.dnd;

import java.util.List;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;

public class SapphireTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private SapphireDiagramEditor diagramEditor;

    public SapphireTemplateTransferDropTargetListener(SapphireDiagramEditor diagramEditor) {
        super((EditPartViewer)diagramEditor.getGraphicalViewer());
        this.setEnablementDeterminedByCommand(true);
        this.diagramEditor = diagramEditor;
    }

    protected void handleDrop() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (this.getTargetEditPart() != null) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.getViewer().getEditDomain().getCommandStack().execute(command);
            } else {
                this.getCurrentEvent().detail = 0;
            }
        } else {
            this.getCurrentEvent().detail = 0;
        }
        this.selectAddedObject();
    }

    private void selectAddedObject() {
        DiagramNodeTemplate nodeTemplate;
        List nodeParts;
        Object model = this.getCreateRequest().getNewObject();
        if (model instanceof DiagramNodeTemplate && (nodeParts = (nodeTemplate = (DiagramNodeTemplate)model).getDiagramNodes()).size() > 0) {
            DiagramNodePart nodePart = (DiagramNodePart)nodeParts.get(nodeParts.size() - 1);
            this.diagramEditor.selectAndDirectEditPart((ISapphirePart)nodePart);
        }
    }
}

