/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.SortedSet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.internal.NonSuspendableListener;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.services.PossibleTypesService;

public final class ElementHandle<T extends Element>
extends Property {
    private T content;

    public ElementHandle(Element element, ElementProperty property) {
        super(element, property);
    }

    public static <TX extends Element> Class<ElementHandle<TX>> of(Class<TX> type) {
        return ElementHandle.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(false);
            if (this.content != null) {
                this.content.refresh();
            }
            this.refreshEnablement(false);
            this.refreshValidation(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshContent(boolean onlyIfNotInitialized) {
        boolean initialized;
        ElementHandle elementHandle = this;
        synchronized (elementHandle) {
            initialized = (this.initialization & 8) != 0;
        }
        if (!initialized || !onlyIfNotInitialized) {
            boolean proceed;
            ElementPropertyBinding binding = this.binding();
            Resource resourceAfter = binding.read();
            ElementHandle elementHandle2 = this;
            synchronized (elementHandle2) {
                Resource resourceBefore = this.content == null ? null : this.content.resource();
                initialized = (this.initialization & 8) != 0;
                proceed = !initialized || resourceBefore != resourceAfter;
            }
            if (proceed) {
                T contentBefore;
                Object contentAfter = null;
                if (resourceAfter != null) {
                    ElementType type = binding.type(resourceAfter);
                    contentAfter = type.instantiate(this, resourceAfter);
                }
                PropertyContentEvent event = null;
                ElementHandle elementHandle3 = this;
                synchronized (elementHandle3) {
                    contentBefore = this.content;
                    this.content = contentAfter;
                    if (initialized) {
                        event = new PropertyContentEvent(this);
                    } else {
                        this.initialization = (byte)(this.initialization | 8);
                    }
                }
                if (contentBefore != null) {
                    try {
                        contentBefore.dispose();
                    }
                    catch (Exception e) {
                        Sapphire.service(LoggingService.class).log(e);
                    }
                }
                this.broadcast(event);
            }
        }
    }

    @Override
    public ElementProperty definition() {
        return (ElementProperty)super.definition();
    }

    @Override
    protected ElementPropertyBinding binding() {
        return (ElementPropertyBinding)super.binding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(Listener listener, ModelPath path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            ModelPath.Segment head;
            this.assertNotDisposed();
            if (path.length() > 0 && ((head = path.head()) instanceof ModelPath.AllDescendentsSegment || head instanceof ModelPath.PropertySegment || head instanceof ModelPath.TypeFilterSegment)) {
                T element2;
                this.attach(listener);
                if (!(this.definition() instanceof ImpliedElementProperty)) {
                    this.attach(new PropagationListener(listener, path));
                }
                if ((element2 = this.content()) != null) {
                    element2.attach(listener, path);
                }
                return;
            }
            super.attach(listener, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(Listener listener, ModelPath path) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            ModelPath.Segment head;
            if (path.length() > 0 && ((head = path.head()) instanceof ModelPath.AllDescendentsSegment || head instanceof ModelPath.PropertySegment || head instanceof ModelPath.TypeFilterSegment)) {
                T element2;
                this.detach(listener);
                if (!(this.definition() instanceof ImpliedElementProperty)) {
                    this.detach(new PropagationListener(listener, path));
                }
                if ((element2 = this.content()) != null) {
                    element2.detach(listener, path);
                }
                return;
            }
            super.detach(listener, path);
        }
    }

    public T content() {
        return this.content(false);
    }

    public T content(boolean force) {
        return this.content(force, (ElementType)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T content(boolean force, ElementType type) {
        this.init();
        this.refreshContent(true);
        SortedSet<ElementType> possible = this.service(PossibleTypesService.class).types();
        if (type != null && !possible.contains(type)) {
            throw new IllegalArgumentException();
        }
        if (force) {
            boolean create;
            ElementType t = type;
            if (t == null) {
                if (possible.size() > 1) {
                    throw new IllegalArgumentException();
                }
                t = possible.first();
            }
            ElementHandle elementHandle = this;
            synchronized (elementHandle) {
                create = this.content == null || this.content.type() != t;
            }
            if (create) {
                this.binding().create(t);
                this.refresh();
                t.instantiate();
            }
        } else {
            ElementHandle elementHandle = this;
            synchronized (elementHandle) {
                if (this.content != null && type != null && this.content.type() != type) {
                    throw new IllegalArgumentException();
                }
            }
        }
        return this.content;
    }

    public <C extends Element> C content(boolean force, Class<C> cl) {
        ElementType type = null;
        if (cl != null && (type = ElementType.read(cl)) == null) {
            throw new IllegalArgumentException();
        }
        return (C)this.content(force, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean empty() {
        Element element = this.root();
        synchronized (element) {
            this.init();
            this.refreshContent(true);
            if (this.definition() instanceof ImpliedElementProperty) {
                for (Property property : this.content.properties()) {
                    if (property.empty()) continue;
                    return false;
                }
                return true;
            }
            return this.content == null;
        }
    }

    @Override
    public void clear() {
        this.init();
        this.refreshContent(true);
        if (this.definition() instanceof ImpliedElementProperty) {
            this.content().clear();
        } else {
            this.binding().remove();
            this.refresh();
        }
    }

    @Override
    public void copy(Element source) {
        this.init();
        this.refreshContent(true);
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (this.definition().isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        Property p = source.property((PropertyDef)this.definition());
        if (this.definition().getClass() == p.definition().getClass()) {
            if (this.definition() instanceof ImpliedElementProperty) {
                this.content().copy((Element)((ElementHandle)p).content());
            } else {
                T sourceChildElement = ((ElementHandle)p).content();
                if (sourceChildElement == null) {
                    this.clear();
                } else {
                    ElementType sourceChildElementType = sourceChildElement.type();
                    if (this.service(PossibleTypesService.class).types().contains(sourceChildElementType)) {
                        this.content(true, sourceChildElementType).copy((Element)sourceChildElement);
                    }
                }
            }
        }
    }

    public String toString() {
        T content = this.content();
        return content == null ? "<null>" : content.toString();
    }

    @Override
    protected void disposeOther() {
        if (this.content != null) {
            this.content.dispose();
            this.content = null;
        }
    }

    private static final class PropagationListener
    extends FilteredListener<PropertyContentEvent>
    implements NonSuspendableListener {
        private final Listener listener;
        private final ModelPath path;

        public PropagationListener(Listener listener, ModelPath path) {
            this.listener = listener;
            this.path = path;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropagationListener) {
                PropagationListener pl = (PropagationListener)obj;
                return this.listener.equals(pl.listener) && this.path.equals(pl.path);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.path.hashCode();
        }

        @Override
        protected void handleTypedEvent(PropertyContentEvent event) {
            Object element = ((ElementHandle)event.property()).content();
            if (element != null) {
                element.attach(this.listener, this.path);
            }
        }
    }
}

