/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public abstract class AggregateFunction
extends Function {
    @Text(value="Property {0}.{1} could not be found.")
    private static LocalizableText missingProperty;
    @Text(value="Property {0}.{1} is not a value property.")
    private static LocalizableText notValueProperty;
    @Text(value="Element type {0} does not contain a value property.")
    private static LocalizableText noValueProperties;

    static {
        LocalizableText.init(AggregateFunction.class);
    }

    protected static abstract class AggregateFunctionResult
    extends FunctionResult {
        private Element lastListParentElement;
        private String lastListenerModelPath;
        private Listener listener;

        public AggregateFunctionResult(Function function, FunctionContext context) {
            super(function, context);
        }

        @Override
        protected final Object evaluate() {
            Object collection = this.operand(0);
            ArrayList<Object> items = new ArrayList<Object>();
            if (collection != null) {
                if (collection instanceof ElementList) {
                    ValueProperty listEntryProperty;
                    ElementList list = (ElementList)collection;
                    ListProperty listProperty = list.definition();
                    ElementType listEntryType = listProperty.getType();
                    if (this.operands().size() > 1) {
                        String listEntryPropertyName = this.cast(this.operand(1), String.class);
                        Object t = listEntryType.property(listEntryPropertyName);
                        if (t == null) {
                            throw new FunctionException(missingProperty.format(listEntryType.getSimpleName(), listEntryPropertyName));
                        }
                        if (!(t instanceof ValueProperty)) {
                            throw new FunctionException(notValueProperty.format(listEntryType.getSimpleName(), listEntryPropertyName));
                        }
                        listEntryProperty = (ValueProperty)t;
                    } else {
                        ValueProperty prop = null;
                        for (PropertyDef propertyDef : listEntryType.properties()) {
                            if (!(propertyDef instanceof ValueProperty)) continue;
                            prop = (ValueProperty)propertyDef;
                            break;
                        }
                        if (prop == null) {
                            throw new FunctionException(noValueProperties.format(listEntryType.getSimpleName()));
                        }
                        listEntryProperty = prop;
                    }
                    for (Element item : list) {
                        items.add(item.property(listEntryProperty).content());
                    }
                    Element listParentElement = list.element();
                    String string = String.valueOf(listProperty.name()) + "/" + listEntryProperty.name();
                    if (this.lastListParentElement != listParentElement || !this.lastListenerModelPath.equals(string)) {
                        if (this.lastListParentElement != null) {
                            this.lastListParentElement.detach(this.listener, this.lastListenerModelPath);
                        }
                        this.lastListParentElement = listParentElement;
                        this.lastListenerModelPath = string;
                        if (this.listener == null) {
                            this.listener = new FilteredListener<PropertyContentEvent>(){

                                @Override
                                protected void handleTypedEvent(PropertyContentEvent event) {
                                    AggregateFunctionResult.this.refresh();
                                }
                            };
                        }
                        listParentElement.attach(this.listener, string);
                    }
                } else if (collection instanceof Object[]) {
                    Object[] objectArray = (Object[])collection;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        items.add(item);
                        ++n2;
                    }
                } else if (collection instanceof Collection) {
                    items.addAll((Collection)collection);
                }
            }
            return this.evaluate(items);
        }

        protected abstract Object evaluate(List<Object> var1);

        @Override
        public void dispose() {
            super.dispose();
            if (this.lastListParentElement != null) {
                this.lastListParentElement.detach(this.listener, this.lastListenerModelPath);
            }
        }
    }
}

