/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml;

import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.XmlBindingTestModel;
import org.eclipse.sapphire.tests.modeling.xml.XmlBindingTestModelAltB;
import org.eclipse.sapphire.tests.modeling.xml.XmlBindingTestModelAltC;
import org.eclipse.sapphire.util.StringUtil;
import org.junit.Test;

public final class XmlBindingTests
extends SapphireTestCase {
    @Test
    public void testValueProperties1() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        XmlBindingTestModel model = (XmlBindingTestModel)XmlBindingTestModel.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        this.testValueProperties(resourceStore, model, this.loadResource(String.valueOf(XmlBindingTests.class.getSimpleName()) + ".testValueProperties1.txt"));
    }

    @Test
    public void testValueProperties2() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        XmlBindingTestModelAltB model = (XmlBindingTestModelAltB)XmlBindingTestModelAltB.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        this.testValueProperties(resourceStore, model, this.loadResource(String.valueOf(XmlBindingTests.class.getSimpleName()) + ".testValueProperties2.txt"));
    }

    @Test
    public void testValueProperties3() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        XmlBindingTestModelAltC model = (XmlBindingTestModelAltC)XmlBindingTestModelAltC.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        this.testValueProperties(resourceStore, model, this.loadResource(String.valueOf(XmlBindingTests.class.getSimpleName()) + ".testValueProperties3.txt"));
    }

    private void testValueProperties(ByteArrayResourceStore resourceStore, XmlBindingTestModel model, String expected) throws Exception {
        model.resource().setCorruptedResourceExceptionInterceptor(new CorruptedResourceExceptionInterceptor(){

            public boolean shouldAttemptRepair() {
                return true;
            }
        });
        model.setValuePropertyA("aaaa");
        XmlBindingTests.assertEquals((Object)"aaaa", (Object)model.getValuePropertyA().text());
        model.setValuePropertyB("bbbb");
        XmlBindingTests.assertEquals((Object)"bbbb", (Object)model.getValuePropertyB().text());
        model.setValuePropertyC("cccc");
        XmlBindingTests.assertEquals((Object)"cccc", (Object)model.getValuePropertyC().text());
        model.setValuePropertyD("dddd");
        XmlBindingTests.assertEquals((Object)"dddd", (Object)model.getValuePropertyD().text());
        model.setValuePropertyE("eeee");
        XmlBindingTests.assertEquals((Object)"eeee", (Object)model.getValuePropertyE().text());
        model.setValuePropertyF("ffff");
        XmlBindingTests.assertEquals((Object)"ffff", (Object)model.getValuePropertyF().text());
        model.resource().save();
        String result = new String(resourceStore.getContents(), StringUtil.UTF8);
        XmlBindingTests.assertEqualsIgnoreNewLineDiffs(expected, result);
    }
}

