/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.forms.CompositeDef;
import org.eclipse.sapphire.ui.forms.CompositePart;
import org.eclipse.sapphire.ui.forms.ContainerPart;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.HelpSystem;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CompositePresentation
extends FormComponentPresentation {
    private ScrolledComposite scrolledComposite;
    private Composite innerComposite;
    private List<FormComponentPresentation> children;

    public CompositePresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    public CompositePart part() {
        return (CompositePart)super.part();
    }

    @Override
    public void render() {
        boolean indent;
        CompositePart part = this.part();
        CompositeDef def = part.definition();
        boolean bl = indent = (Boolean)def.getIndent().content() != false && !(part.parent() instanceof MasterDetailsContentNodePart);
        if (indent) {
            Label label = new Label(this.composite(), 0);
            label.setLayoutData((Object)GridLayoutUtil.gd());
            this.register((Control)label);
        }
        boolean scaleVertically = (Boolean)def.getScaleVertically().content();
        int width = part.getWidth(-1);
        int height = part.getHeight(-1);
        Composite outerComposite = this.renderOuterComposite(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhhint(GridLayoutUtil.gdhspan(scaleVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), indent ? 1 : 2), height), width));
        this.render(outerComposite);
    }

    protected void render(Composite composite) {
        CompositePart part = this.part();
        CompositeDef def = part.definition();
        composite.setBackground(this.resources().color(part.getBackgroundColor()));
        composite.setBackgroundMode(1);
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        boolean scrollVertically = (Boolean)def.getScrollVertically().content();
        boolean scrollHorizontally = (Boolean)def.getScrollHorizontally().content();
        if (scrollVertically || scrollHorizontally) {
            int style = (scrollVertically ? 512 : 0) | (scrollHorizontally ? 256 : 0);
            this.scrolledComposite = new ScrolledComposite(composite, style);
            this.scrolledComposite.setExpandHorizontal(true);
            this.scrolledComposite.setExpandVertical(true);
            this.scrolledComposite.setBackground(composite.getBackground());
            this.scrolledComposite.setBackgroundMode(1);
        }
        int marginLeft = (Integer)def.getMarginLeft().content();
        int marginRight = (Integer)def.getMarginRight().content();
        int marginTop = (Integer)def.getMarginTop().content();
        int marginBottom = (Integer)def.getMarginBottom().content();
        this.innerComposite = new Composite((Composite)(this.scrolledComposite != null ? this.scrolledComposite : composite), 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (this.getChildren().length == 0) {
                    return new Point(0, 0);
                }
                return super.computeSize(wHint, hHint, changed);
            }
        };
        this.innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, marginLeft, marginRight, marginTop, marginBottom));
        if (this.scrolledComposite != null) {
            this.scrolledComposite.setContent((Control)this.innerComposite);
            this.scrolledComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        } else {
            this.innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        }
        ISapphireDocumentation doc = (ISapphireDocumentation)def.getDocumentation().content();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                HelpSystem.setHelp((Control)this.innerComposite, docdef);
            }
        }
        this.refresh();
        this.attachPartListener((Listener)new FilteredListener<ContainerPart.VisibleChildrenEvent>(){

            protected void handleTypedEvent(ContainerPart.VisibleChildrenEvent event) {
                CompositePresentation.this.refresh();
            }
        });
    }

    protected Composite renderOuterComposite(GridData gd) {
        Composite composite = new Composite(this.composite(), 0);
        composite.setLayoutData((Object)gd);
        composite.setBackground(this.resources().color(this.part().getBackgroundColor()));
        composite.setBackgroundMode(1);
        this.register((Control)composite);
        return composite;
    }

    protected void renderChildren(Composite composite) {
        ListFactory childrenListFactory = ListFactory.start();
        for (FormComponentPart formComponentPart : this.part().children().visible()) {
            childrenListFactory.add((Object)formComponentPart.createPresentation(this, composite));
        }
        this.children = childrenListFactory.result();
        for (FormComponentPresentation formComponentPresentation : this.children) {
            if (formComponentPresentation.disposed()) continue;
            formComponentPresentation.render();
        }
    }

    @Override
    public void refresh() {
        boolean needToLayout = false;
        if (this.children != null) {
            for (FormComponentPresentation child : this.children) {
                child.dispose();
            }
            this.children = null;
            needToLayout = true;
        }
        Control[] controlArray = this.innerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.renderChildren(this.innerComposite);
        if (this.scrolledComposite != null) {
            this.scrolledComposite.setMinSize(this.innerComposite.computeSize(-1, -1));
        }
        if (needToLayout) {
            this.layout();
        }
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            for (FormComponentPresentation child : this.children) {
                child.dispose();
            }
            this.children = null;
        }
        this.scrolledComposite = null;
        this.innerComposite = null;
        super.dispose();
    }
}

