/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.forms.swt.AbstractBinding;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextFieldBinding
extends AbstractBinding {
    private Text text;
    private String textContent;
    private ValueNormalizationService valueNormalizationService;
    private DelayedTasksExecutor.Task onTextContentModifyTask;

    public TextFieldBinding(PropertyEditorPresentation propertyEditorPresentation, Text text) {
        super(propertyEditorPresentation, (Control)text);
    }

    @Override
    protected void initialize(PropertyEditorPresentation propertyEditorPresentation, Control control) {
        super.initialize(propertyEditorPresentation, control);
        this.onTextContentModifyTask = new DelayedTasksExecutor.Task(){

            @Override
            public int getPriority() {
                return 100;
            }

            @Override
            public void run() {
                TextFieldBinding.this.updateModel();
                TextFieldBinding.this.updateTargetAttributes();
            }
        };
        this.text = (Text)control;
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextFieldBinding.this.updateTextContent(TextFieldBinding.this.text.getText());
            }
        });
        this.valueNormalizationService = (ValueNormalizationService)this.property().service(ValueNormalizationService.class);
    }

    public Value<?> property() {
        return (Value)super.property();
    }

    protected void updateTextContent(String textContent) {
        this.textContent = textContent;
        DelayedTasksExecutor.schedule(this.onTextContentModifyTask);
    }

    @Override
    protected void doUpdateModel() {
        if (!this.text.isDisposed() && (this.text.getStyle() & 8) == 0) {
            this.property().write((Object)this.textContent, true);
        }
    }

    @Override
    protected void doUpdateTarget() {
        String newValue;
        String oldValue = this.valueNormalizationService.normalize(this.text.getText());
        if (!MiscUtil.equal((Object)oldValue, (Object)(newValue = this.valueNormalizationService.normalize(this.property().text(false))))) {
            this.text.setText(newValue == null ? "" : newValue);
        }
    }
}

