/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.swt.gef.figures.IShapeFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.TextPresentation;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class TextFigure
extends Label
implements IShapeFigure {
    private DiagramResourceCache resourceCache;
    private TextPresentation textPresentation;
    private Rectangle availableArea;
    private int horizontalAlignment;
    private int verticalAlignment;
    private Point textLocation;
    private Text swtText;
    private double cachedZoom = -1.0;
    private Font scaledFont;
    private ZoomManager zoomMgr;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            TextFigure.this.updateScaledFont(newZoom);
        }
    };

    public TextFigure(DiagramResourceCache resourceCache, TextPresentation textPresentation) {
        this.resourceCache = resourceCache;
        this.textPresentation = textPresentation;
        this.setForegroundColor(resourceCache.getColor(textPresentation.getTextColor()));
        this.horizontalAlignment = this.getSwtTextAlignment((HorizontalAlignment)textPresentation.getLayoutConstraint().getHorizontalAlignment().content());
        this.setLabelAlignment(2);
        this.verticalAlignment = this.getSwtTextAlignment((VerticalAlignment)textPresentation.getLayoutConstraint().getVerticalAlignment().content());
        this.setFont(this.resourceCache.getFont(textPresentation.getFontDef()));
        GraphicalViewer viewer = textPresentation.getConfigurationManager().getDiagramEditor().getGraphicalViewer();
        Composite composite = (Composite)viewer.getControl();
        this.swtText = new Text(composite, 0);
        this.swtText.setVisible(false);
        this.zoomMgr = (ZoomManager)viewer.getProperty(ZoomManager.class.toString());
        this.cachedZoom = -1.0;
        this.updateScaledFont(this.zoomMgr.getZoom());
        this.zoomMgr.addZoomListener(this.zoomListener);
        this.setText(textPresentation.getContent());
    }

    public Rectangle getAvailableArea() {
        Rectangle nodeBounds = this.getClientArea();
        if (this.availableArea != null) {
            return new Rectangle(this.availableArea.x + nodeBounds.x, this.availableArea.y + nodeBounds.y, this.availableArea.width, this.availableArea.height);
        }
        return nodeBounds;
    }

    public void setAvailableArea(Rectangle availableArea) {
        Rectangle nodeBounds = this.getClientArea();
        this.availableArea = new Rectangle(availableArea.x - nodeBounds.x, availableArea.y - nodeBounds.y, availableArea.width, availableArea.height);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.setLabelAlignment(this.horizontalAlignment);
    }

    public TextPresentation getTextPresentation() {
        return this.textPresentation;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        if (this.getText().equals(s)) {
            return;
        }
        this.swtText.setText(s);
        super.setText(s);
    }

    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            this.minSize.setSize(this.getLayoutManager().getMinimumSize((IFigure)this, w, h));
        }
        Dimension labelSize = this.getTextPresentation().truncatable() ? this.calculateLabelSize(this.getTextUtilities().getTextExtents(this.getTruncationString(), this.getFont()).intersect(this.getTextUtilities().getTextExtents(this.getText(), this.getFont()))) : this.calculateLabelSize(this.getTextUtilities().getTextExtents(this.getText(), this.getFont()));
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(labelSize);
        return this.minSize;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            org.eclipse.swt.graphics.Point textSize = this.swtText.computeSize(-1, -1);
            double zoom = this.zoomMgr.getZoom();
            if (zoom != 1.0) {
                textSize.x = (int)((double)textSize.x / zoom);
                textSize.y = (int)((double)textSize.y / zoom);
            }
            this.prefSize = new Dimension(textSize.x, textSize.y);
            Insets insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
            if (this.getLayoutManager() != null) {
                this.prefSize.union(this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint));
            }
        }
        if (wHint >= 0 && wHint < this.prefSize.width) {
            Dimension minSize = this.getMinimumSize(wHint, hHint);
            Dimension result = this.prefSize.getCopy();
            result.width = Math.min(result.width, wHint);
            result.width = Math.max(minSize.width, result.width);
            return result;
        }
        return this.prefSize;
    }

    protected Point getTextLocation() {
        if (this.textLocation != null) {
            return this.textLocation;
        }
        this.textLocation = new Point();
        Dimension offset = this.getSize().getDifference(this.getTextSize());
        offset.width += this.getTextSize().width - this.getSubStringTextSize().width;
        switch (this.getLabelAlignment()) {
            case 2: {
                offset.scale(0.5);
                break;
            }
            case 1: {
                offset.scale(0.0);
                break;
            }
            case 4: {
                offset.scale(1.0);
                break;
            }
            case 8: {
                offset.height = 0;
                offset.scale(0.5);
                break;
            }
            case 32: {
                offset.height *= 2;
                offset.scale(0.5);
                break;
            }
            default: {
                offset.scale(0.5);
            }
        }
        this.textLocation.translate(offset);
        return this.textLocation;
    }

    public void invalidate() {
        super.invalidate();
        this.textLocation = null;
    }

    private int getSwtTextAlignment(HorizontalAlignment horizontalAlign) {
        int alignment = 2;
        switch (horizontalAlign) {
            case LEFT: {
                alignment = 1;
                break;
            }
            case RIGHT: {
                alignment = 4;
                break;
            }
        }
        return alignment;
    }

    private int getSwtTextAlignment(VerticalAlignment verticalAlign) {
        int alignment = 2;
        switch (verticalAlign) {
            case TOP: {
                alignment = 8;
                break;
            }
            case BOTTOM: {
                alignment = 32;
                break;
            }
        }
        return alignment;
    }

    @Override
    public void setSelected(boolean b) {
    }

    @Override
    public void setFocus(boolean b) {
    }

    private void updateScaledFont(double zoom) {
        if (this.cachedZoom == zoom) {
            return;
        }
        Font font = this.getFont();
        this.disposeScaledFont();
        this.cachedZoom = zoom;
        if (zoom == 1.0) {
            this.swtText.setFont(font);
        } else {
            FontData fd = font.getFontData()[0];
            fd.setHeight((int)((double)fd.getHeight() * zoom));
            this.scaledFont = new Font(null, fd);
            this.swtText.setFont(this.scaledFont);
        }
    }

    private void disposeScaledFont() {
        if (this.scaledFont != null) {
            this.scaledFont.dispose();
            this.scaledFont = null;
        }
    }
}

