/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.util.CollectionsUtil;
import org.eclipse.sapphire.util.ListFactory;

public abstract class ContainerPart<T extends FormComponentPart>
extends FormComponentPart {
    private Children children;

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), new Function(){

            public String name() {
                return "VisibleIfChildrenVisible";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected void init() {
                        ContainerPart.this.attach((Listener)new FilteredListener<VisibleChildrenEvent>(){

                            protected void handleTypedEvent(VisibleChildrenEvent event) {
                                this.refresh();
                            }
                        });
                    }

                    protected Object evaluate() {
                        return !ContainerPart.this.children().visible().isEmpty();
                    }
                };
            }
        }});
    }

    protected abstract Children initChildren();

    public final Children children() {
        if (this.children == null) {
            this.children = this.initChildren();
        }
        return this.children;
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (SapphirePart child : this.children().visible()) {
            factory.merge(child.validation());
        }
        return factory.create();
    }

    @Override
    public boolean setFocus() {
        this.broadcast(new SapphirePart.FocusReceivedEvent(this));
        for (SapphirePart child : this.children().visible()) {
            if (!child.setFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        this.broadcast(new SapphirePart.FocusReceivedEvent(this));
        for (SapphirePart child : this.children().visible()) {
            if (!child.setFocus(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            this.children.dispose();
            this.children = null;
        }
        super.dispose();
    }

    public abstract class Children {
        private List<T> all;
        private List<T> visible;
        private boolean initializingVisibleChildren;

        protected abstract void init(ListFactory<T> var1);

        public List<T> all() {
            if (this.all == null) {
                ListFactory factory = ListFactory.start();
                this.init(factory);
                this.all = factory.result();
                Listener listener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof PartValidationEvent) {
                            ContainerPart.this.refreshValidation();
                        } else if (event instanceof PartVisibilityEvent) {
                            Children.this.refreshVisibleChildren();
                        }
                    }
                };
                for (SapphirePart part : this.all) {
                    part.initialize();
                    part.attach(listener);
                }
            }
            return this.all;
        }

        public List<T> visible() {
            if (this.visible == null) {
                if (this.initializingVisibleChildren) {
                    this.visible = ListFactory.empty();
                } else {
                    this.initializingVisibleChildren = true;
                    try {
                        this.refreshVisibleChildren();
                    }
                    finally {
                        this.initializingVisibleChildren = false;
                    }
                }
            }
            return this.visible;
        }

        private void refreshVisibleChildren() {
            ListFactory factory = ListFactory.start();
            for (FormComponentPart child : this.all()) {
                if (!child.visible()) continue;
                factory.add((Object)child);
            }
            List fresh = factory.result();
            if (this.visible == null) {
                this.visible = fresh;
            } else if (!CollectionsUtil.equalsBasedOnEntryIdentity(this.visible, (List)fresh)) {
                this.visible = fresh;
                ContainerPart.this.broadcast(new VisibleChildrenEvent(ContainerPart.this));
                ContainerPart.this.refreshValidation();
            }
        }

        private void dispose() {
            if (this.all != null) {
                for (FormComponentPart child : this.all) {
                    child.dispose();
                }
                this.all = null;
                this.visible = null;
            }
        }
    }

    public static final class VisibleChildrenEvent
    extends SapphirePart.PartEvent {
        public VisibleChildrenEvent(ContainerPart<?> part) {
            super(part);
        }

        @Override
        public ContainerPart<?> part() {
            return (ContainerPart)super.part();
        }
    }
}

