/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class StaticImageService
extends ImageService {
    @Text(value="Failed to load image {1} referenced by {0} class.")
    private static LocalizableText failedToLoadMessage;
    private ImageData image;

    static {
        LocalizableText.init(StaticImageService.class);
    }

    @Override
    protected void initImageService() {
        ElementType type = this.context(Element.class).type();
        Image imageAnnotation = type.getAnnotation(Image.class);
        Class<?> imageAnnotationHostClass = type.findAnnotationHostClass(imageAnnotation);
        String imagePath = imageAnnotation.path();
        this.image = ImageData.readFromClassLoader(imageAnnotationHostClass, imagePath).optional();
        if (this.image == null) {
            String msg = failedToLoadMessage.format(imageAnnotationHostClass.getName(), imagePath);
            Sapphire.service(LoggingService.class).logError(msg);
        }
    }

    @Override
    protected ImageData compute() {
        return this.image;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            return context.find(Element.class).type().getAnnotation(Image.class) != null;
        }
    }
}

