/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0002;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0002.TestXmlXsd0002Element2b;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0002.TestXmlXsd0002ModelRoot;
import org.eclipse.sapphire.util.StringUtil;
import org.junit.Test;

public final class TestXmlXsd0002
extends SapphireTestCase {
    private static final String SCHEMA_LOCATION = "http://www.eclipse.org/sapphire/tests/xml/xsd/0002";

    @Test
    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)SCHEMA_LOCATION);
        XmlElementDefinition rootElementDef = schema.getElement("element");
        XmlSequenceGroup rootContentModel = (XmlSequenceGroup)rootElementDef.getContentModel();
        List nestedContent = rootContentModel.getNestedContent();
        TestXmlXsd0002.assertEquals((long)4L, (long)nestedContent.size());
        TestXmlXsd0002.assertEquals((Object)"aaa", (Object)((XmlElementDefinition)nestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((Object)"bbb", (Object)((XmlElementDefinition)nestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((Object)"ccc", (Object)((XmlElementDefinition)nestedContent.get(2)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((Object)"element-2b", (Object)((XmlElementDefinition)nestedContent.get(3)).getName().getLocalPart());
        XmlSequenceGroup childContentModel = (XmlSequenceGroup)rootContentModel.findChildElementContentModel(new QName(SCHEMA_LOCATION, "element-2b"));
        List childNestedContent = childContentModel.getNestedContent();
        TestXmlXsd0002.assertEquals((long)3L, (long)childNestedContent.size());
        TestXmlXsd0002.assertEquals((Object)"aaa-2b", (Object)((XmlElementDefinition)childNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((Object)"bbb-2b", (Object)((XmlElementDefinition)childNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((Object)"ccc-2b", (Object)((XmlElementDefinition)childNestedContent.get(2)).getName().getLocalPart());
    }

    @Test
    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        TestXmlXsd0002ModelRoot model = (TestXmlXsd0002ModelRoot)TestXmlXsd0002ModelRoot.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        model.setCcc("ccc");
        model.setAaa("aaa");
        TestXmlXsd0002Element2b element2b = model.getElement2();
        element2b.setCcc2("ccc2");
        element2b.setBbb2("bbb2");
        element2b.setAaa2("aaa2");
        model.setBbb("bbb");
        model.resource().save();
        String result = new String(resourceStore.getContents(), StringUtil.UTF8);
        TestXmlXsd0002.assertEqualsIgnoreNewLineDiffs(this.loadResource("0002.txt"), result);
    }
}

