/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.contextbuttons;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.DefaultActionImage;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonPad;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.PopupMenu;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.PositionedContextButton;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.Tooltip;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramConnectionEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.SapphireDiagramEditorPageEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ContextButton
extends Clickable
implements MouseMotionListener,
ActionListener {
    private double getCurrentTransparency = 0.0;
    private PositionedContextButton positionedContextButton;
    private SapphireAction sapphireAction;
    private ContextButtonPad contextButtonPad;
    private double opacity;
    private Tooltip tooltip;

    public ContextButton(PositionedContextButton positionedContextButton, ContextButtonPad contextButtonPad) {
        this.positionedContextButton = positionedContextButton;
        this.contextButtonPad = contextButtonPad;
        this.sapphireAction = positionedContextButton.getSapphireAction();
        this.setBorder(null);
        this.setCurrentTransparency(contextButtonPad.getCurrentTransparency());
        this.setOpacity(this.getPositionedContextButton().getDefaultOpacity());
        String label = this.getLabel(this.getSapphireAction());
        if (label != null && label.length() > 0) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            this.tooltip.setHeader(label);
        }
        if (this.getSapphireAction().getToolTip() != null && this.getSapphireAction().getToolTip().length() > 0) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            this.tooltip.setDescription(this.getSapphireAction().getToolTip());
        }
        this.setToolTip((IFigure)this.tooltip);
        this.addMouseMotionListener(this);
        this.addActionListener(this);
        if (this.getSapphireAction().getActiveHandlers().size() > 1) {
            this.setEnabled(this.getExecutableMenuEntries().size() > 0);
        } else {
            this.setEnabled(this.getSapphireAction().isEnabled());
        }
    }

    public final PositionedContextButton getPositionedContextButton() {
        return this.positionedContextButton;
    }

    public final SapphireAction getSapphireAction() {
        return this.sapphireAction;
    }

    public final ContextButtonPad getContextButtonPad() {
        return this.contextButtonPad;
    }

    public final double getZoomLevel() {
        return this.getContextButtonPad().getZoomLevel();
    }

    public final SapphireDiagramEditor getEditor() {
        return this.getContextButtonPad().getEditor();
    }

    private void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    private double getAdjustedOpacity() {
        if (this.getCurrentTransparency() != 0.0) {
            return this.opacity * this.getCurrentTransparency();
        }
        return this.opacity;
    }

    protected void paintFigure(Graphics graphics) {
        boolean isSubmenuButton;
        int lw = (int)((double)this.getPositionedContextButton().getLineWidth() * this.getZoomLevel());
        graphics.setLineWidth(lw);
        graphics.setAntialias(1);
        graphics.setAlpha((int)(this.getAdjustedOpacity() * 255.0));
        Path pathOuterLine = this.createPath(1);
        Path pathMiddleLine = this.createPath(2);
        Path pathFill = this.createPath(3);
        graphics.setBackgroundColor(this.getAdjustedColor(this.getPositionedContextButton().getFillColor()));
        graphics.fillPath(pathFill);
        graphics.setForegroundColor(this.getAdjustedColor(this.getPositionedContextButton().getMiddleLineColor()));
        graphics.drawPath(pathMiddleLine);
        graphics.setForegroundColor(this.getAdjustedColor(this.getPositionedContextButton().getOuterLineColor()));
        graphics.drawPath(pathOuterLine);
        pathOuterLine.dispose();
        pathMiddleLine.dispose();
        pathFill.dispose();
        pathOuterLine = null;
        pathMiddleLine = null;
        pathFill = null;
        double imageOpacity = 1.0;
        graphics.setAlpha((int)(imageOpacity * 255.0));
        Image originalImage = this.getActionImage(this.getSapphireAction());
        if (originalImage == null) {
            return;
        }
        Image image = !this.isEnabled() ? new Image(originalImage.getDevice(), originalImage, 1) : new Image(originalImage.getDevice(), originalImage, 0);
        org.eclipse.swt.graphics.Rectangle rect = image.getBounds();
        Rectangle newRect = new Rectangle(0, 0, rect.width, rect.height);
        newRect.scale(this.getZoomLevel());
        newRect.x = this.getBounds().x + (this.getBounds().width - newRect.width) / 2;
        newRect.y = this.getBounds().y + (this.getBounds().height - newRect.height) / 2;
        graphics.drawImage(image, rect.x, rect.y, rect.width, rect.height, newRect.x, newRect.y, newRect.width, newRect.height);
        image.dispose();
        List menuEntries = this.getSapphireAction().getActiveHandlers();
        boolean bl = isSubmenuButton = menuEntries != null && menuEntries.size() > 1;
        if (isSubmenuButton) {
            this.paintSubmenuIndicator(graphics, newRect);
        }
    }

    private void paintSubmenuIndicator(Graphics graphics, Rectangle newRect) {
        int x = newRect.x;
        int y = newRect.y;
        int w = newRect.width;
        int h = newRect.height;
        PointList pl = new PointList();
        pl.addPoint(x + w, y + h * 3 / 4);
        pl.addPoint(x + w, y + h);
        pl.addPoint(x + w * 3 / 4, y + h);
        this.preparePaintIndicator(graphics);
        graphics.drawPolygon(pl);
        graphics.fillPolygon(pl);
    }

    private void preparePaintIndicator(Graphics graphics) {
        graphics.setLineWidth(1);
        Color outerLineColor = this.getPositionedContextButton().getOuterLineColor();
        org.eclipse.swt.graphics.Color adjustedColor = this.getAdjustedColor(outerLineColor);
        graphics.setForegroundColor(adjustedColor);
        graphics.setBackgroundColor(adjustedColor);
    }

    private org.eclipse.swt.graphics.Color getAdjustedColor(Color color) {
        SapphireDiagramEditor editor = this.getContextButtonPad().getEditor();
        if (!this.isEnabled()) {
            int disabledAdjustment = 80;
            int r = Math.min(255, color.red() + disabledAdjustment);
            int g = Math.min(255, color.green() + disabledAdjustment);
            int b = Math.min(255, color.blue() + disabledAdjustment);
            color = new Color(r, g, b);
        }
        org.eclipse.swt.graphics.Color swtColor = editor.getResourceCache().getColor(color);
        return swtColor;
    }

    protected Path createPath(int shrinkLines) {
        double zoom = this.getZoomLevel();
        int lw = (int)((double)this.getPositionedContextButton().getLineWidth() * zoom);
        Rectangle r = FigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, shrinkLines * lw);
        double zoomedCorner = (double)this.getPositionedContextButton().getCornerRadius() * zoom;
        int corner = (int)Math.max(1.0, zoomedCorner - ((double)((shrinkLines - 1) * lw) + zoomedCorner / 64.0));
        Path path = new Path(null);
        path.moveTo((float)r.x, (float)r.y);
        path.addArc((float)r.x, (float)r.y, (float)corner, (float)corner, 90.0f, 90.0f);
        path.addArc((float)r.x, (float)(r.y + r.height - corner), (float)corner, (float)corner, 180.0f, 90.0f);
        path.addArc((float)(r.x + r.width - corner), (float)(r.y + r.height - corner), (float)corner, (float)corner, 270.0f, 90.0f);
        path.addArc((float)(r.x + r.width - corner), (float)r.y, (float)corner, (float)corner, 0.0f, 90.0f);
        path.close();
        return path;
    }

    public void handleMouseEntered(MouseEvent event) {
        this.setOpacity(this.getPositionedContextButton().getMouseOverOpacity());
        this.repaint();
        super.handleMouseEntered(event);
    }

    public void handleMouseExited(MouseEvent event) {
        this.setOpacity(this.getPositionedContextButton().getDefaultOpacity());
        this.repaint();
        super.handleMouseExited(event);
    }

    public void handleMousePressed(MouseEvent event) {
        this.setToolTip(null);
        this.setOpacity(this.getPositionedContextButton().getMouseDownOpacity());
        this.repaint();
        super.handleMousePressed(event);
    }

    public void handleMouseReleased(MouseEvent event) {
        this.setToolTip((IFigure)this.tooltip);
        this.setOpacity(this.getPositionedContextButton().getMouseOverOpacity());
        this.repaint();
        super.handleMouseReleased(event);
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void actionPerformed(ActionEvent event) {
        if (this.getSapphireAction().getActiveHandlers().size() > 1) {
            List<SapphireActionHandler> menuEntries = this.getExecutableMenuEntries();
            if (menuEntries.size() == 0) {
                return;
            }
            PopupMenuLabelProvider labelProvider = new PopupMenuLabelProvider();
            PopupMenu popupMenu = new PopupMenu(menuEntries, (ILabelProvider)labelProvider);
            boolean b = popupMenu.show((Control)Display.getCurrent().getActiveShell());
            if (b) {
                SapphireActionHandler handler = (SapphireActionHandler)popupMenu.getResult();
                this.executeActionHandler(handler);
            }
        } else if (this.getSapphireAction().isEnabled()) {
            this.executeActionHandler(this.getSapphireAction().getFirstActiveHandler());
        }
        this.getEditor().getContextButtonManager().refresh();
    }

    private List<SapphireActionHandler> getExecutableMenuEntries() {
        List activeHandlers = this.getSapphireAction().getActiveHandlers();
        ArrayList<SapphireActionHandler> menuEntries = new ArrayList<SapphireActionHandler>();
        for (SapphireActionHandler handler : activeHandlers) {
            if (!handler.isEnabled()) continue;
            menuEntries.add(handler);
        }
        return menuEntries;
    }

    private Image getActionHandlerImage(SapphireActionHandler handler) {
        ImageData imageData = handler.getImage(16);
        if (imageData == null) {
            return DefaultActionImage.getDefaultActionImage();
        }
        ImageDescriptor imageDescriptor = SwtUtil.toImageDescriptor((ImageData)imageData);
        return imageDescriptor.createImage();
    }

    private Image getActionImage(SapphireAction action) {
        ImageData imageData = action.getImage(16);
        if (imageData == null) {
            return DefaultActionImage.getDefaultActionImage();
        }
        ImageDescriptor imageDescriptor = SwtUtil.toImageDescriptor((ImageData)imageData);
        return imageDescriptor.createImage();
    }

    private String getLabel(SapphireAction action) {
        String label = action.getLabel();
        label = LabelTransformer.transform((String)label, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
        return label;
    }

    private String getLabel(SapphireActionHandler handler) {
        String label = handler.getLabel();
        label = LabelTransformer.transform((String)label, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false);
        return label;
    }

    private void executeActionHandler(SapphireActionHandler handler) {
        List<GraphicalEditPart> editParts = this.contextButtonPad.getEditParts();
        for (GraphicalEditPart editPart : editParts) {
            DiagramPresentation presentation;
            if (editPart instanceof SapphireDiagramEditorPageEditPart) {
                presentation = ((SapphireDiagramEditorPageEditPart)editPart).getPresentation();
            } else if (editPart instanceof DiagramNodeEditPart) {
                presentation = ((DiagramNodeEditPart)editPart).getPresentation();
            } else if (editPart instanceof ShapeEditPart) {
                presentation = ((ShapeEditPart)editPart).getShapePresentation();
            } else if (editPart instanceof DiagramConnectionEditPart) {
                presentation = ((DiagramConnectionEditPart)editPart).getPresentation();
            } else {
                throw new IllegalStateException();
            }
            handler.execute((Presentation)presentation);
        }
    }

    public double getCurrentTransparency() {
        return this.getCurrentTransparency;
    }

    public void setCurrentTransparency(double getCurrentTransparency) {
        this.getCurrentTransparency = getCurrentTransparency;
    }

    private class PopupMenuLabelProvider
    extends LabelProvider {
        private PopupMenuLabelProvider() {
        }

        public String getText(Object element) {
            SapphireActionHandler handler = (SapphireActionHandler)element;
            return ContextButton.this.getLabel(handler);
        }

        public Image getImage(Object element) {
            SapphireActionHandler handler = (SapphireActionHandler)element;
            return ContextButton.this.getActionHandlerImage(handler);
        }
    }
}

