/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactRepository;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;

public final class CreateContactActionHandler
extends SapphireActionHandler {
    private Property property;

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.property = ((PropertyEditorPart)this.getPart()).property();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                CreateContactActionHandler.this.refreshEnablementState();
            }
        };
        ((ContactRepository)this.property.element().nearest(ContactRepository.class)).attach((Listener)listener, "Contacts/Name");
        this.property.attach((Listener)listener);
        this.refreshEnablementState();
        this.attach((Listener)new FilteredListener<DisposeEvent>((Listener)listener){
            private final /* synthetic */ Listener val$listener;
            {
                this.val$listener = listener;
            }

            protected void handleTypedEvent(DisposeEvent event) {
                ((ContactRepository)CreateContactActionHandler.this.property.element().nearest(ContactRepository.class)).detach(this.val$listener, "Contacts/Name");
                CreateContactActionHandler.this.property.detach(this.val$listener);
            }
        });
    }

    private void refreshEnablementState() {
        boolean enabled;
        String name = ((Value)this.property).text();
        ContactRepository cdb = (ContactRepository)this.property.element().nearest(ContactRepository.class);
        if (name == null) {
            enabled = false;
        } else {
            enabled = true;
            for (Contact contact : cdb.getContacts()) {
                if (!name.equals(contact.getName().text())) continue;
                enabled = false;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    protected Object run(Presentation context) {
        String name = ((Value)this.property).text();
        ContactRepository cdb = (ContactRepository)this.property.element().nearest(ContactRepository.class);
        Contact newContact = (Contact)cdb.getContacts().insert();
        newContact.setName(name);
        return null;
    }
}

