/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.observable;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ObservableSet;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.util.SetFactory;
import org.junit.Test;

public final class ObservableSetTests
extends SapphireTestCase {
    @Test
    public void Size() throws Exception {
        HashSet<String> base = new HashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        ObservableSetTests.assertEquals((long)0L, (long)observable.size());
        base.add("a");
        base.add("b");
        ObservableSetTests.assertEquals((long)2L, (long)observable.size());
        base.clear();
        ObservableSetTests.assertEquals((long)0L, (long)observable.size());
    }

    @Test
    public void Empty() throws Exception {
        HashSet<String> base = new HashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        ObservableSetTests.assertTrue((boolean)observable.isEmpty());
        base.add("a");
        ObservableSetTests.assertFalse((boolean)observable.isEmpty());
        base.clear();
        ObservableSetTests.assertTrue((boolean)observable.isEmpty());
    }

    @Test
    public void Contains() throws Exception {
        HashSet<String> base = new HashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        ObservableSetTests.assertTrue((boolean)observable.contains((Object)"a"));
        ObservableSetTests.assertFalse((boolean)observable.contains((Object)"b"));
        ObservableSetTests.assertFalse((boolean)observable.contains(new Object()));
    }

    @Test
    public void ContainsAll() throws Exception {
        HashSet<String> base = new HashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        base.add("c");
        ObservableSetTests.assertTrue((boolean)observable.containsAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"a", "b"})));
        ObservableSetTests.assertFalse((boolean)observable.containsAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"a", "d"})));
    }

    @Test
    public void Iterator() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        Iterator itr = observable.iterator();
        ObservableSetTests.assertTrue((boolean)itr.hasNext());
        ObservableSetTests.assertEquals((Object)"a", itr.next());
        ObservableSetTests.assertTrue((boolean)itr.hasNext());
        ObservableSetTests.assertEquals((Object)"b", itr.next());
        itr.remove();
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableSetTests.assertEquals((long)1L, (long)log.size());
        ObservableSetTests.assertTrue((boolean)itr.hasNext());
        ObservableSetTests.assertEquals((Object)"c", itr.next());
        ObservableSetTests.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void ToArray1() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        Object[] array = observable.toArray();
        ObservableSetTests.assertEquals((long)2L, (long)array.length);
        ObservableSetTests.assertEquals((Object)"a", (Object)array[0]);
        ObservableSetTests.assertEquals((Object)"b", (Object)array[1]);
    }

    @Test
    public void ToArray2() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        Object[] array = new String[2];
        String[] result = (String[])observable.toArray(array);
        ObservableSetTests.assertSame((Object)array, (Object)result);
        ObservableSetTests.assertEquals((Object)"a", (Object)array[0]);
        ObservableSetTests.assertEquals((Object)"b", (Object)array[1]);
    }

    @Test
    public void Add() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.add((Object)"c");
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "b", "c"}), base);
        ObservableSetTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.add((Object)"a");
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "b", "c"}), base);
        ObservableSetTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void AddAll() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.addAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"a", "c", "d"}));
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "b", "c", "d"}), base);
        ObservableSetTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.addAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"a", "b"}));
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "b", "c", "d"}), base);
        ObservableSetTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void Remove() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.remove((Object)"b");
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableSetTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.remove((Object)"d");
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableSetTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void RemoveAll() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.removeAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"b", "c", "d"}));
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a"}), base);
        ObservableSetTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.removeAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"d", "e"}));
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a"}), base);
        ObservableSetTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void RetainAll() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.retainAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"a", "c"}));
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableSetTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.retainAll((Collection)SetFactory.unmodifiable((Object[])new String[]{"a", "c"}));
        ObservableSetTests.assertEquals((Object)SetFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableSetTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void Clear() throws Exception {
        LinkedHashSet<String> base = new LinkedHashSet<String>();
        ObservableSet observable = new ObservableSet(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.clear();
        ObservableSetTests.assertTrue((boolean)base.isEmpty());
        ObservableSetTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.clear();
        ObservableSetTests.assertTrue((boolean)base.isEmpty());
        ObservableSetTests.assertEquals((long)0L, (long)log.size());
    }
}

