/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.util.MiscUtil;

public final class ConditionalFunction
extends Function {
    public static ConditionalFunction create(Function condition, Function positive, Function negative) {
        ConditionalFunction function = new ConditionalFunction();
        function.init(condition, positive, negative);
        return function;
    }

    @Override
    public String name() {
        return "Conditional";
    }

    @Override
    public boolean operator() {
        return true;
    }

    @Override
    public int precedence() {
        return 7;
    }

    @Override
    public FunctionResult evaluate(final FunctionContext context) {
        return new FunctionResult(this, context){
            private Boolean lastConditionValue;
            private FunctionResult lastActiveBranch;
            private Listener listener;

            @Override
            protected void init() {
                super.init();
                this.listener = new Listener(){

                    @Override
                    public void handle(Event event) {
                        this.refresh();
                    }
                };
            }

            @Override
            protected List<FunctionResult> initOperands() {
                return Collections.singletonList(this.function().operands().get(0).evaluate(context));
            }

            @Override
            protected Object evaluate() {
                Boolean conditionValue = this.cast(this.operand(0), Boolean.class);
                if (this.lastActiveBranch != null && !MiscUtil.equal(this.lastConditionValue, conditionValue)) {
                    this.lastConditionValue = null;
                    this.lastActiveBranch.dispose();
                    this.lastActiveBranch = null;
                }
                if (this.lastActiveBranch == null) {
                    this.lastConditionValue = conditionValue;
                    FunctionResult res = conditionValue != false ? this.function().operand(1).evaluate(context) : this.function().operand(2).evaluate(context);
                    if (this.lastActiveBranch != null) {
                        throw new IllegalStateException();
                    }
                    this.lastActiveBranch = res;
                    this.lastActiveBranch.attach(this.listener);
                }
                return this.lastActiveBranch.value();
            }

            @Override
            public void dispose() {
                super.dispose();
                if (this.lastActiveBranch != null) {
                    this.lastActiveBranch.dispose();
                }
            }
        };
    }

    @Override
    public void toString(StringBuilder buf, boolean topLevel) {
        this.toString(buf, this.operand(0));
        buf.append(" ? ");
        this.toString(buf, this.operand(1));
        buf.append(" : ");
        this.toString(buf, this.operand(2));
    }

    private void toString(StringBuilder buf, Function operand) {
        boolean parens;
        boolean bl = parens = this.precedence() <= operand.precedence();
        if (parens) {
            buf.append("( ");
        }
        operand.toString(buf, false);
        if (parens) {
            buf.append(" )");
        }
    }
}

