/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.property;

import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.element.TestElement;
import org.junit.Test;

public final class PropertyTests
extends SapphireTestCase {
    @Test
    public void HoldsElement() throws Exception {
        TestElement a = (TestElement)TestElement.TYPE.instantiate();
        try {
            TestElement aa = (TestElement)a.getElement().content(true);
            PropertyTests.assertTrue((boolean)a.getElement().holds((Element)aa));
            PropertyTests.assertFalse((boolean)a.getValue().holds((Element)aa));
            PropertyTests.assertFalse((boolean)a.getTransient().holds((Element)aa));
            PropertyTests.assertFalse((boolean)a.getList().holds((Element)aa));
            TestElement aaa = (TestElement)aa.getList().insert();
            PropertyTests.assertTrue((boolean)a.getElement().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)a.getValue().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)a.getTransient().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)a.getList().holds((Element)aaa));
            PropertyTests.assertTrue((boolean)aa.getList().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)aa.getValue().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)aa.getTransient().holds((Element)aaa));
            PropertyTests.assertFalse((boolean)aa.getElement().holds((Element)aaa));
        }
        finally {
            a.dispose();
        }
    }

    @Test
    public void HoldsProperty() throws Exception {
        TestElement a = (TestElement)TestElement.TYPE.instantiate();
        try {
            TestElement aa = (TestElement)a.getElement().content(true);
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getValue()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getTransient()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getElement()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aa.getList()));
            PropertyTests.assertFalse((boolean)a.getValue().holds(aa.getValue()));
            PropertyTests.assertFalse((boolean)a.getTransient().holds(aa.getValue()));
            PropertyTests.assertFalse((boolean)a.getList().holds(aa.getValue()));
            TestElement aaa = (TestElement)aa.getList().insert();
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getValue()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getTransient()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getElement()));
            PropertyTests.assertTrue((boolean)a.getElement().holds(aaa.getList()));
            PropertyTests.assertFalse((boolean)a.getValue().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)a.getTransient().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)a.getList().holds(aaa.getValue()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getValue()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getTransient()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getElement()));
            PropertyTests.assertTrue((boolean)aa.getList().holds(aaa.getList()));
            PropertyTests.assertFalse((boolean)aa.getValue().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)aa.getTransient().holds(aaa.getValue()));
            PropertyTests.assertFalse((boolean)aa.getElement().holds(aaa.getValue()));
        }
        finally {
            a.dispose();
        }
    }

    @Test
    public void Suspend() {
        EventLog log = new EventLog();
        TestElement a = (TestElement)TestElement.TYPE.instantiate();
        try {
            a.attach(log, "*");
            TestElement aa = (TestElement)a.getElement().content(true);
            aa.setValue("abc");
            aa.getList().insert();
            PropertyTests.assertEquals((long)3L, (long)log.size());
            PropertyTests.assertPropertyContentEvent(log.event(0), a.getElement());
            PropertyTests.assertPropertyContentEvent(log.event(1), aa.getValue());
            PropertyTests.assertPropertyContentEvent(log.event(2), aa.getList());
            log.clear();
            Disposable suspension = a.getElement().suspend();
            try {
                aa.setValue("def");
                ((TestElement)aa.getList().insert()).setValue("ghi");
                ((TestElement)aa.getElement().content(true)).setValue("klm");
                PropertyTests.assertEquals((long)0L, (long)log.size());
                a.setValue("nop");
                PropertyTests.assertEquals((long)1L, (long)log.size());
                PropertyTests.assertPropertyContentEvent(log.event(0), a.getValue());
                log.clear();
            }
            finally {
                suspension.dispose();
            }
            PropertyTests.assertEquals((long)5L, (long)log.size());
            PropertyTests.assertPropertyContentEvent(log.event(0), aa.getValue());
            PropertyTests.assertPropertyContentEvent(log.event(1), aa.getList());
            PropertyTests.assertPropertyContentEvent(log.event(2), ((TestElement)aa.getList().get(1)).getValue());
            PropertyTests.assertPropertyContentEvent(log.event(3), aa.getElement());
            PropertyTests.assertPropertyContentEvent(log.event(4), ((TestElement)aa.getElement().content()).getValue());
        }
        finally {
            a.dispose();
        }
    }
}

