/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.internal;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;

public class OutlineNodeListMemberActionHandlerCondition
extends SapphireCondition {
    @Override
    protected boolean evaluate() {
        MasterDetailsEditorPagePart page;
        List<MasterDetailsContentNodePart> nodes;
        ISapphirePart part = this.getPart();
        if (part instanceof MasterDetailsContentNodePart) {
            return this.check((MasterDetailsContentNodePart)part);
        }
        if (part instanceof MasterDetailsEditorPagePart && !(nodes = (page = (MasterDetailsEditorPagePart)part).outline().getSelectedNodes()).isEmpty()) {
            MasterDetailsContentNodePart parent = null;
            for (MasterDetailsContentNodePart node : page.outline().getSelectedNodes()) {
                if (parent == null) {
                    parent = node.getParentNode();
                    continue;
                }
                if (parent == node.getParentNode()) continue;
                return false;
            }
            for (MasterDetailsContentNodePart node : page.outline().getSelectedNodes()) {
                if (this.check(node)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean check(MasterDetailsContentNodePart node) {
        Element element = node.getModelElement();
        if (element.parent() instanceof ElementList && !element.parent().definition().isReadOnly()) {
            ISapphirePart parentPart = node.parent();
            if (parentPart != null && parentPart instanceof MasterDetailsContentNodePart) {
                MasterDetailsContentNodePart parentNode = (MasterDetailsContentNodePart)parentPart;
                return element != parentNode.getLocalModelElement();
            }
            return true;
        }
        return false;
    }
}

