/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.binding.list;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Counter;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.tests.binding.list.TestElement;

public final class TestResource
extends Resource {
    private final List<Object> list = new ArrayList<Object>(2);
    private final Counter readUnderlyingListCounter = new Counter();

    public TestResource() {
        super(null);
    }

    public List<Object> list() {
        return this.list;
    }

    public Counter getReadUnderlyingListCounter() {
        return this.readUnderlyingListCounter;
    }

    protected PropertyBinding createBinding(Property property) {
        if (property.definition() == TestElement.PROP_LIST) {
            return new LayeredListPropertyBinding(){

                public ElementType type(Resource resource) {
                    return Element.TYPE;
                }

                protected Resource resource(Object obj) {
                    return new ListEntryResource(TestResource.this, obj);
                }

                protected List<?> readUnderlyingList() {
                    TestResource.this.readUnderlyingListCounter.increment();
                    return TestResource.this.list;
                }

                protected Object insertUnderlyingObject(ElementType type, int position) {
                    Object object = new Object();
                    TestResource.this.list.add(position, object);
                    return object;
                }

                public void move(Resource resource, int position) {
                    Object object = ((ListEntryResource)resource).object();
                    int oldPosition = TestResource.this.list.indexOf(object);
                    if (position < oldPosition) {
                        TestResource.this.list.remove(oldPosition);
                        TestResource.this.list.add(position, object);
                    } else {
                        TestResource.this.list.add(position, object);
                        TestResource.this.list.remove(oldPosition);
                    }
                }

                public void remove(Resource resource) {
                    Object object = ((ListEntryResource)resource).object();
                    TestResource.this.list.remove(object);
                }
            };
        }
        throw new IllegalStateException();
    }

    private static final class ListEntryResource
    extends Resource {
        private final Object object;

        public ListEntryResource(Resource parent, Object object) {
            super(parent);
            if (object == null) {
                throw new IllegalArgumentException();
            }
            this.object = object;
        }

        public Object object() {
            return this.object;
        }

        protected PropertyBinding createBinding(Property property) {
            throw new IllegalStateException();
        }
    }
}

