/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.conversion;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.java.JavaIdentifier;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.conversion.DateConversionTestElement;
import org.eclipse.sapphire.tests.conversion.XmlConversionTestElement;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ConversionTests
extends SapphireTestCase {
    @Test
    public void testStringToBoolean() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)Boolean.TRUE, (Object)service.convert((Object)"true", Boolean.class));
        ConversionTests.assertEquals((Object)Boolean.TRUE, (Object)service.convert((Object)"TRUE", Boolean.class));
        ConversionTests.assertEquals((Object)Boolean.TRUE, (Object)service.convert((Object)"True", Boolean.class));
        ConversionTests.assertEquals((Object)Boolean.TRUE, (Object)service.convert((Object)"tRuE", Boolean.class));
        ConversionTests.assertEquals((Object)Boolean.FALSE, (Object)service.convert((Object)"false", Boolean.class));
        ConversionTests.assertEquals((Object)Boolean.FALSE, (Object)service.convert((Object)"FALSE", Boolean.class));
        ConversionTests.assertEquals((Object)Boolean.FALSE, (Object)service.convert((Object)"False", Boolean.class));
        ConversionTests.assertEquals((Object)Boolean.FALSE, (Object)service.convert((Object)"fAlSe", Boolean.class));
        ConversionTests.assertNull((Object)service.convert((Object)"yes", Boolean.class));
        ConversionTests.assertNull((Object)service.convert((Object)"no", Boolean.class));
        ConversionTests.assertNull((Object)service.convert((Object)"0", Boolean.class));
        ConversionTests.assertNull((Object)service.convert((Object)"1", Boolean.class));
        ConversionTests.assertNull((Object)service.convert((Object)"abcdef", Boolean.class));
    }

    @Test
    public void testBooleanToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"true", (Object)service.convert((Object)Boolean.TRUE, String.class));
        ConversionTests.assertEquals((Object)"false", (Object)service.convert((Object)Boolean.FALSE, String.class));
    }

    @Test
    public void testStringToByte() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)-128, (Object)service.convert((Object)"-128", Byte.class));
        ConversionTests.assertEquals((Object)-48, (Object)service.convert((Object)"-48", Byte.class));
        ConversionTests.assertEquals((Object)0, (Object)service.convert((Object)"0", Byte.class));
        ConversionTests.assertEquals((Object)47, (Object)service.convert((Object)"47", Byte.class));
        ConversionTests.assertEquals((Object)127, (Object)service.convert((Object)"127", Byte.class));
    }

    @Test
    public void testByteToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-128", (Object)service.convert((Object)-128, String.class));
        ConversionTests.assertEquals((Object)"-48", (Object)service.convert((Object)-48, String.class));
        ConversionTests.assertEquals((Object)"0", (Object)service.convert((Object)0, String.class));
        ConversionTests.assertEquals((Object)"47", (Object)service.convert((Object)47, String.class));
        ConversionTests.assertEquals((Object)"127", (Object)service.convert((Object)127, String.class));
    }

    @Test
    public void testStringToShort() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)Short.MIN_VALUE, (Object)service.convert((Object)"-32768", Short.class));
        ConversionTests.assertEquals((Object)-128, (Object)service.convert((Object)"-128", Short.class));
        ConversionTests.assertEquals((Object)-48, (Object)service.convert((Object)"-48", Short.class));
        ConversionTests.assertEquals((Object)0, (Object)service.convert((Object)"0", Short.class));
        ConversionTests.assertEquals((Object)47, (Object)service.convert((Object)"47", Short.class));
        ConversionTests.assertEquals((Object)127, (Object)service.convert((Object)"127", Short.class));
        ConversionTests.assertEquals((Object)Short.MAX_VALUE, (Object)service.convert((Object)"32767", Short.class));
    }

    @Test
    public void testShortToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-32768", (Object)service.convert((Object)Short.MIN_VALUE, String.class));
        ConversionTests.assertEquals((Object)"-128", (Object)service.convert((Object)-128, String.class));
        ConversionTests.assertEquals((Object)"-48", (Object)service.convert((Object)-48, String.class));
        ConversionTests.assertEquals((Object)"0", (Object)service.convert((Object)0, String.class));
        ConversionTests.assertEquals((Object)"47", (Object)service.convert((Object)47, String.class));
        ConversionTests.assertEquals((Object)"127", (Object)service.convert((Object)127, String.class));
        ConversionTests.assertEquals((Object)"32767", (Object)service.convert((Object)Short.MAX_VALUE, String.class));
    }

    @Test
    public void testStringToInteger() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)Integer.MIN_VALUE, (Object)service.convert((Object)"-2147483648", Integer.class));
        ConversionTests.assertEquals((Object)Short.MIN_VALUE, (Object)service.convert((Object)"-32768", Integer.class));
        ConversionTests.assertEquals((Object)-128, (Object)service.convert((Object)"-128", Integer.class));
        ConversionTests.assertEquals((Object)-48, (Object)service.convert((Object)"-48", Integer.class));
        ConversionTests.assertEquals((Object)0, (Object)service.convert((Object)"0", Integer.class));
        ConversionTests.assertEquals((Object)47, (Object)service.convert((Object)"47", Integer.class));
        ConversionTests.assertEquals((Object)127, (Object)service.convert((Object)"127", Integer.class));
        ConversionTests.assertEquals((Object)Short.MAX_VALUE, (Object)service.convert((Object)"32767", Integer.class));
        ConversionTests.assertEquals((Object)Integer.MAX_VALUE, (Object)service.convert((Object)"2147483647", Integer.class));
    }

    @Test
    public void testIntegerToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-2147483648", (Object)service.convert((Object)Integer.MIN_VALUE, String.class));
        ConversionTests.assertEquals((Object)"-32768", (Object)service.convert((Object)Short.MIN_VALUE, String.class));
        ConversionTests.assertEquals((Object)"-128", (Object)service.convert((Object)-128, String.class));
        ConversionTests.assertEquals((Object)"-48", (Object)service.convert((Object)-48, String.class));
        ConversionTests.assertEquals((Object)"0", (Object)service.convert((Object)0, String.class));
        ConversionTests.assertEquals((Object)"47", (Object)service.convert((Object)47, String.class));
        ConversionTests.assertEquals((Object)"127", (Object)service.convert((Object)127, String.class));
        ConversionTests.assertEquals((Object)"32767", (Object)service.convert((Object)Short.MAX_VALUE, String.class));
        ConversionTests.assertEquals((Object)"2147483647", (Object)service.convert((Object)Integer.MAX_VALUE, String.class));
    }

    @Test
    public void testStringToLong() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)Long.MIN_VALUE, (Object)service.convert((Object)"-9223372036854775808", Long.class));
        ConversionTests.assertEquals((Object)Integer.MIN_VALUE, (Object)service.convert((Object)"-2147483648", Long.class));
        ConversionTests.assertEquals((Object)-32768L, (Object)service.convert((Object)"-32768", Long.class));
        ConversionTests.assertEquals((Object)-128L, (Object)service.convert((Object)"-128", Long.class));
        ConversionTests.assertEquals((Object)-48L, (Object)service.convert((Object)"-48", Long.class));
        ConversionTests.assertEquals((Object)0L, (Object)service.convert((Object)"0", Long.class));
        ConversionTests.assertEquals((Object)47L, (Object)service.convert((Object)"47", Long.class));
        ConversionTests.assertEquals((Object)127L, (Object)service.convert((Object)"127", Long.class));
        ConversionTests.assertEquals((Object)32767L, (Object)service.convert((Object)"32767", Long.class));
        ConversionTests.assertEquals((Object)Integer.MAX_VALUE, (Object)service.convert((Object)"2147483647", Long.class));
        ConversionTests.assertEquals((Object)Long.MAX_VALUE, (Object)service.convert((Object)"9223372036854775807", Long.class));
    }

    @Test
    public void testLongToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-9223372036854775808", (Object)service.convert((Object)Long.MIN_VALUE, String.class));
        ConversionTests.assertEquals((Object)"-2147483648", (Object)service.convert((Object)Integer.MIN_VALUE, String.class));
        ConversionTests.assertEquals((Object)"-32768", (Object)service.convert((Object)-32768L, String.class));
        ConversionTests.assertEquals((Object)"-128", (Object)service.convert((Object)-128L, String.class));
        ConversionTests.assertEquals((Object)"-48", (Object)service.convert((Object)-48L, String.class));
        ConversionTests.assertEquals((Object)"0", (Object)service.convert((Object)0L, String.class));
        ConversionTests.assertEquals((Object)"47", (Object)service.convert((Object)47L, String.class));
        ConversionTests.assertEquals((Object)"127", (Object)service.convert((Object)127L, String.class));
        ConversionTests.assertEquals((Object)"32767", (Object)service.convert((Object)32767L, String.class));
        ConversionTests.assertEquals((Object)"2147483647", (Object)service.convert((Object)Integer.MAX_VALUE, String.class));
        ConversionTests.assertEquals((Object)"9223372036854775807", (Object)service.convert((Object)Long.MAX_VALUE, String.class));
    }

    @Test
    public void testStringToFloat() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)Float.valueOf(-15.773523f), (Object)service.convert((Object)"-15.773523", Float.class));
        ConversionTests.assertEquals((Object)Float.valueOf(0.0f), (Object)service.convert((Object)"0.0", Float.class));
        ConversionTests.assertEquals((Object)Float.valueOf(15.773523f), (Object)service.convert((Object)"15.773523", Float.class));
    }

    @Test
    public void testFloatToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-15.773523", (Object)service.convert((Object)Float.valueOf(-15.773523f), String.class));
        ConversionTests.assertEquals((Object)"0.0", (Object)service.convert((Object)Float.valueOf(0.0f), String.class));
        ConversionTests.assertEquals((Object)"15.773523", (Object)service.convert((Object)Float.valueOf(15.773523f), String.class));
    }

    @Test
    public void testStringToDouble() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)-15.773523, (Object)service.convert((Object)"-15.773523", Double.class));
        ConversionTests.assertEquals((Object)0.0, (Object)service.convert((Object)"0.0", Double.class));
        ConversionTests.assertEquals((Object)15.773523, (Object)service.convert((Object)"15.773523", Double.class));
    }

    @Test
    public void testDoubleToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-15.773523", (Object)service.convert((Object)-15.773523, String.class));
        ConversionTests.assertEquals((Object)"0.0", (Object)service.convert((Object)0.0, String.class));
        ConversionTests.assertEquals((Object)"15.773523", (Object)service.convert((Object)15.773523, String.class));
    }

    @Test
    public void testStringToBigInteger() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new BigInteger("-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808"), (Object)service.convert((Object)"-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("-9223372036854775808"), (Object)service.convert((Object)"-9223372036854775808", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("-2147483648"), (Object)service.convert((Object)"-2147483648", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("-32768"), (Object)service.convert((Object)"-32768", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("-128"), (Object)service.convert((Object)"-128", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("-48"), (Object)service.convert((Object)"-48", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("0"), (Object)service.convert((Object)"0", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("47"), (Object)service.convert((Object)"47", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("127"), (Object)service.convert((Object)"127", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("32767"), (Object)service.convert((Object)"32767", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("2147483647"), (Object)service.convert((Object)"2147483647", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("9223372036854775807"), (Object)service.convert((Object)"9223372036854775807", BigInteger.class));
        ConversionTests.assertEquals((Object)new BigInteger("92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807"), (Object)service.convert((Object)"92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807", BigInteger.class));
    }

    @Test
    public void testBigIntegerToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808", (Object)service.convert((Object)new BigInteger("-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808"), String.class));
        ConversionTests.assertEquals((Object)"-9223372036854775808", (Object)service.convert((Object)new BigInteger("-9223372036854775808"), String.class));
        ConversionTests.assertEquals((Object)"-2147483648", (Object)service.convert((Object)new BigInteger("-2147483648"), String.class));
        ConversionTests.assertEquals((Object)"-32768", (Object)service.convert((Object)new BigInteger("-32768"), String.class));
        ConversionTests.assertEquals((Object)"-128", (Object)service.convert((Object)new BigInteger("-128"), String.class));
        ConversionTests.assertEquals((Object)"-48", (Object)service.convert((Object)new BigInteger("-48"), String.class));
        ConversionTests.assertEquals((Object)"0", (Object)service.convert((Object)new BigInteger("0"), String.class));
        ConversionTests.assertEquals((Object)"47", (Object)service.convert((Object)new BigInteger("47"), String.class));
        ConversionTests.assertEquals((Object)"127", (Object)service.convert((Object)new BigInteger("127"), String.class));
        ConversionTests.assertEquals((Object)"32767", (Object)service.convert((Object)new BigInteger("32767"), String.class));
        ConversionTests.assertEquals((Object)"2147483647", (Object)service.convert((Object)new BigInteger("2147483647"), String.class));
        ConversionTests.assertEquals((Object)"9223372036854775807", (Object)service.convert((Object)new BigInteger("9223372036854775807"), String.class));
        ConversionTests.assertEquals((Object)"92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807", (Object)service.convert((Object)new BigInteger("92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807"), String.class));
    }

    @Test
    public void testStringToBigDecimal() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new BigDecimal("-922337203685477580892233720368547758089223372036854775808.92233720368547758089223372036854775808"), (Object)service.convert((Object)"-922337203685477580892233720368547758089223372036854775808.92233720368547758089223372036854775808", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808"), (Object)service.convert((Object)"-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("-9223372036854775808"), (Object)service.convert((Object)"-9223372036854775808", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("-2147483648"), (Object)service.convert((Object)"-2147483648", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("-32768"), (Object)service.convert((Object)"-32768", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("-128"), (Object)service.convert((Object)"-128", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("-48"), (Object)service.convert((Object)"-48", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("0"), (Object)service.convert((Object)"0", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("47"), (Object)service.convert((Object)"47", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("127"), (Object)service.convert((Object)"127", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("32767"), (Object)service.convert((Object)"32767", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("2147483647"), (Object)service.convert((Object)"2147483647", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("9223372036854775807"), (Object)service.convert((Object)"9223372036854775807", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807"), (Object)service.convert((Object)"92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807", BigDecimal.class));
        ConversionTests.assertEquals((Object)new BigDecimal("922337203685477580792233720368547758079223372036854775807.92233720368547758079223372036854775807"), (Object)service.convert((Object)"922337203685477580792233720368547758079223372036854775807.92233720368547758079223372036854775807", BigDecimal.class));
    }

    @Test
    public void testBigDecimalToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"-922337203685477580892233720368547758089223372036854775808.92233720368547758089223372036854775808", (Object)service.convert((Object)new BigDecimal("-922337203685477580892233720368547758089223372036854775808.92233720368547758089223372036854775808"), String.class));
        ConversionTests.assertEquals((Object)"-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808", (Object)service.convert((Object)new BigDecimal("-92233720368547758089223372036854775808922337203685477580892233720368547758089223372036854775808"), String.class));
        ConversionTests.assertEquals((Object)"-9223372036854775808", (Object)service.convert((Object)new BigDecimal("-9223372036854775808"), String.class));
        ConversionTests.assertEquals((Object)"-2147483648", (Object)service.convert((Object)new BigDecimal("-2147483648"), String.class));
        ConversionTests.assertEquals((Object)"-32768", (Object)service.convert((Object)new BigDecimal("-32768"), String.class));
        ConversionTests.assertEquals((Object)"-128", (Object)service.convert((Object)new BigDecimal("-128"), String.class));
        ConversionTests.assertEquals((Object)"-48", (Object)service.convert((Object)new BigDecimal("-48"), String.class));
        ConversionTests.assertEquals((Object)"0", (Object)service.convert((Object)new BigDecimal("0"), String.class));
        ConversionTests.assertEquals((Object)"47", (Object)service.convert((Object)new BigDecimal("47"), String.class));
        ConversionTests.assertEquals((Object)"127", (Object)service.convert((Object)new BigDecimal("127"), String.class));
        ConversionTests.assertEquals((Object)"32767", (Object)service.convert((Object)new BigDecimal("32767"), String.class));
        ConversionTests.assertEquals((Object)"2147483647", (Object)service.convert((Object)new BigDecimal("2147483647"), String.class));
        ConversionTests.assertEquals((Object)"9223372036854775807", (Object)service.convert((Object)new BigDecimal("9223372036854775807"), String.class));
        ConversionTests.assertEquals((Object)"92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807", (Object)service.convert((Object)new BigDecimal("92233720368547758079223372036854775807922337203685477580792233720368547758079223372036854775807"), String.class));
        ConversionTests.assertEquals((Object)"922337203685477580792233720368547758079223372036854775807.92233720368547758079223372036854775807", (Object)service.convert((Object)new BigDecimal("922337203685477580792233720368547758079223372036854775807.92233720368547758079223372036854775807"), String.class));
    }

    @Test
    public void testStringToDate() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd").parse("2013-01-15"), (Object)service.convert((Object)"2013-01-15", Date.class));
        ConversionTests.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse("2013-01-15T18:38:24"), (Object)service.convert((Object)"2013-01-15T18:38:24", Date.class));
        ConversionTests.assertNull((Object)service.convert((Object)"2013.01.15", Date.class));
        DateConversionTestElement element = (DateConversionTestElement)DateConversionTestElement.TYPE.instantiate();
        service = (MasterConversionService)element.property(DateConversionTestElement.PROP_DATE_1).service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd").parse("2013-01-15"), (Object)service.convert((Object)"2013-01-15", Date.class));
        ConversionTests.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse("2013-01-15T18:38:24"), (Object)service.convert((Object)"2013-01-15T18:38:24", Date.class));
        ConversionTests.assertNull((Object)service.convert((Object)"2013.01.15", Date.class));
        service = (MasterConversionService)element.property(DateConversionTestElement.PROP_DATE_2).service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd").parse("2013-01-15"), (Object)service.convert((Object)"2013.01.15", Date.class));
        ConversionTests.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd").parse("2013-01-15"), (Object)service.convert((Object)"01/15/2013", Date.class));
        ConversionTests.assertNull((Object)service.convert((Object)"2013-01-15", Date.class));
    }

    @Test
    public void testDateToString() throws Exception {
        SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ");
        Date date = fullDateFormat.parse("2013-01-15T18:38:24.000-0800");
        DateConversionTestElement element = (DateConversionTestElement)DateConversionTestElement.TYPE.instantiate();
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)fullDateFormat.format(date), (Object)service.convert((Object)date, String.class));
        service = (MasterConversionService)element.property(DateConversionTestElement.PROP_DATE_1).service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)fullDateFormat.format(date), (Object)service.convert((Object)date, String.class));
        service = (MasterConversionService)element.property(DateConversionTestElement.PROP_DATE_2).service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"2013.01.15", (Object)service.convert((Object)date, String.class));
    }

    @Test
    public void testStringToFileName() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new FileName("abc"), (Object)service.convert((Object)"abc", FileName.class));
        ConversionTests.assertEquals((Object)new FileName("abc.txt"), (Object)service.convert((Object)"abc.txt", FileName.class));
        ConversionTests.assertNull((Object)service.convert((Object)"folder/abc.txt", FileName.class));
    }

    @Test
    public void testFileNameToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"abc", (Object)service.convert((Object)new FileName("abc"), String.class));
        ConversionTests.assertEquals((Object)"abc.txt", (Object)service.convert((Object)new FileName("abc.txt"), String.class));
    }

    @Test
    public void testStringToPath() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new Path("abc"), (Object)service.convert((Object)"abc", Path.class));
        ConversionTests.assertEquals((Object)new Path("abc.txt"), (Object)service.convert((Object)"abc.txt", Path.class));
        ConversionTests.assertEquals((Object)new Path("folder/abc.txt"), (Object)service.convert((Object)"folder/abc.txt", Path.class));
        ConversionTests.assertEquals((Object)new Path("x/y/z/folder/abc.txt"), (Object)service.convert((Object)"x/y/z/folder/abc.txt", Path.class));
    }

    @Test
    public void testPathToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"abc", (Object)service.convert((Object)new Path("abc"), String.class));
        ConversionTests.assertEquals((Object)"abc.txt", (Object)service.convert((Object)new Path("abc.txt"), String.class));
        ConversionTests.assertEquals((Object)"folder/abc.txt", (Object)service.convert((Object)new Path("folder/abc.txt"), String.class));
        ConversionTests.assertEquals((Object)"x/y/z/folder/abc.txt", (Object)service.convert((Object)new Path("x/y/z/folder/abc.txt"), String.class));
    }

    @Test
    public void testStringToUri() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new URI("http://example.org/absolute/URI/with/absolute/path/to/resource.txt"), (Object)service.convert((Object)"http://example.org/absolute/URI/with/absolute/path/to/resource.txt", URI.class));
        ConversionTests.assertEquals((Object)new URI("ftp://example.org/resource.txt"), (Object)service.convert((Object)"ftp://example.org/resource.txt", URI.class));
        ConversionTests.assertEquals((Object)new URI("relative/path/to/resource.txt"), (Object)service.convert((Object)"relative/path/to/resource.txt", URI.class));
        ConversionTests.assertEquals((Object)new URI("../../../resource.txt"), (Object)service.convert((Object)"../../../resource.txt", URI.class));
    }

    @Test
    public void testUriToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"http://example.org/absolute/URI/with/absolute/path/to/resource.txt", (Object)service.convert((Object)new URI("http://example.org/absolute/URI/with/absolute/path/to/resource.txt"), String.class));
        ConversionTests.assertEquals((Object)"ftp://example.org/resource.txt", (Object)service.convert((Object)new URI("ftp://example.org/resource.txt"), String.class));
        ConversionTests.assertEquals((Object)"relative/path/to/resource.txt", (Object)service.convert((Object)new URI("relative/path/to/resource.txt"), String.class));
        ConversionTests.assertEquals((Object)"../../../resource.txt", (Object)service.convert((Object)new URI("../../../resource.txt"), String.class));
    }

    @Test
    public void testStringToUrl() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new URL("http://example.org/absolute/URI/with/absolute/path/to/resource.txt"), (Object)service.convert((Object)"http://example.org/absolute/URI/with/absolute/path/to/resource.txt", URL.class));
        ConversionTests.assertEquals((Object)new URL("ftp://example.org/resource.txt"), (Object)service.convert((Object)"ftp://example.org/resource.txt", URL.class));
        ConversionTests.assertNull((Object)service.convert((Object)"relative/path/to/resource.txt", URL.class));
        ConversionTests.assertNull((Object)service.convert((Object)"../../../resource.txt", URL.class));
    }

    @Test
    public void testUrlToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"http://example.org/absolute/URI/with/absolute/path/to/resource.txt", (Object)service.convert((Object)new URL("http://example.org/absolute/URI/with/absolute/path/to/resource.txt"), String.class));
        ConversionTests.assertEquals((Object)"ftp://example.org/resource.txt", (Object)service.convert((Object)new URL("ftp://example.org/resource.txt"), String.class));
    }

    @Test
    public void testStringToVersion() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new Version("1"), (Object)service.convert((Object)"1", Version.class));
        ConversionTests.assertEquals((Object)new Version("1.2"), (Object)service.convert((Object)"1.2", Version.class));
        ConversionTests.assertEquals((Object)new Version("1.2.3"), (Object)service.convert((Object)"1.2.3", Version.class));
        ConversionTests.assertEquals((Object)new Version("1.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20"), (Object)service.convert((Object)"1.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20", Version.class));
        ConversionTests.assertNull((Object)service.convert((Object)"1..2", Version.class));
        ConversionTests.assertNull((Object)service.convert((Object)"1.abc", Version.class));
    }

    @Test
    public void testVersionToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"1", (Object)service.convert((Object)new Version("1"), String.class));
        ConversionTests.assertEquals((Object)"1.2", (Object)service.convert((Object)new Version("1.2"), String.class));
        ConversionTests.assertEquals((Object)"1.2.3", (Object)service.convert((Object)new Version("1.2.3"), String.class));
        ConversionTests.assertEquals((Object)"1.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20", (Object)service.convert((Object)new Version("1.2.3.4.5.6.7.8.9.10.11.12.13.14.15.16.17.18.19.20"), String.class));
    }

    @Test
    public void testStringToVersionConstraint() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new VersionConstraint("1"), (Object)service.convert((Object)"1", VersionConstraint.class));
        ConversionTests.assertEquals((Object)new VersionConstraint("1.2"), (Object)service.convert((Object)"1.2", VersionConstraint.class));
        ConversionTests.assertEquals((Object)new VersionConstraint("1.2,3.4,5.6"), (Object)service.convert((Object)"1.2,3.4,5.6", VersionConstraint.class));
        ConversionTests.assertEquals((Object)new VersionConstraint("[1.2-3.4)"), (Object)service.convert((Object)"[1.2-3.4)", VersionConstraint.class));
        ConversionTests.assertEquals((Object)new VersionConstraint("[1.2-3.4),[5.6"), (Object)service.convert((Object)"[1.2-3.4),[5.6", VersionConstraint.class));
        ConversionTests.assertNull((Object)service.convert((Object)"[1.2--3", VersionConstraint.class));
        ConversionTests.assertNull((Object)service.convert((Object)"[1.2-3.4}", VersionConstraint.class));
    }

    @Test
    public void testVersionConstraintToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)"1", (Object)service.convert((Object)new VersionConstraint("1"), String.class));
        ConversionTests.assertEquals((Object)"1.2", (Object)service.convert((Object)new VersionConstraint("1.2"), String.class));
        ConversionTests.assertEquals((Object)"1.2,3.4,5.6", (Object)service.convert((Object)new VersionConstraint("1.2,3.4,5.6"), String.class));
        ConversionTests.assertEquals((Object)"[1.2-3.4)", (Object)service.convert((Object)new VersionConstraint("[1.2-3.4)"), String.class));
        ConversionTests.assertEquals((Object)"[1.2-3.4),[5.6", (Object)service.convert((Object)new VersionConstraint("[1.2-3.4),[5.6"), String.class));
    }

    @Test
    public void testIFileToWorkspaceFileResourceStore() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        IProject project = this.project();
        IFile xmlFile = project.getFile("file.xml");
        xmlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        WorkspaceFileResourceStore xmlFileStore = (WorkspaceFileResourceStore)service.convert((Object)xmlFile, WorkspaceFileResourceStore.class);
        ConversionTests.assertNotNull((Object)xmlFileStore);
        IFile txtFile = project.getFile("file.txt");
        txtFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        WorkspaceFileResourceStore txtFileStore = (WorkspaceFileResourceStore)service.convert((Object)txtFile, WorkspaceFileResourceStore.class);
        ConversionTests.assertNotNull((Object)txtFileStore);
        IFile binFile = project.getFile("file.bin");
        binFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        WorkspaceFileResourceStore binFileStore = (WorkspaceFileResourceStore)service.convert((Object)binFile, WorkspaceFileResourceStore.class);
        ConversionTests.assertNotNull((Object)binFileStore);
    }

    @Test
    public void testIFileToByteArrayResourceStore() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        IProject project = this.project();
        IFile xmlFile = project.getFile("file.xml");
        xmlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        ByteArrayResourceStore xmlFileStore = (ByteArrayResourceStore)service.convert((Object)xmlFile, ByteArrayResourceStore.class);
        ConversionTests.assertNotNull((Object)xmlFileStore);
        IFile txtFile = project.getFile("file.txt");
        txtFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        ByteArrayResourceStore txtFileStore = (ByteArrayResourceStore)service.convert((Object)txtFile, ByteArrayResourceStore.class);
        ConversionTests.assertNotNull((Object)txtFileStore);
        IFile binFile = project.getFile("file.bin");
        binFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        ByteArrayResourceStore binFileStore = (ByteArrayResourceStore)service.convert((Object)binFile, ByteArrayResourceStore.class);
        ConversionTests.assertNotNull((Object)binFileStore);
    }

    @Test
    public void testIFileToResourceStore() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        IProject project = this.project();
        IFile xmlFile = project.getFile("file.xml");
        xmlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        ResourceStore xmlFileStore = (ResourceStore)service.convert((Object)xmlFile, ResourceStore.class);
        ConversionTests.assertNotNull((Object)xmlFileStore);
        IFile txtFile = project.getFile("file.txt");
        txtFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        ResourceStore txtFileStore = (ResourceStore)service.convert((Object)txtFile, ResourceStore.class);
        ConversionTests.assertNotNull((Object)txtFileStore);
        IFile binFile = project.getFile("file.bin");
        binFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        ResourceStore binFileStore = (ResourceStore)service.convert((Object)binFile, ResourceStore.class);
        ConversionTests.assertNotNull((Object)binFileStore);
    }

    @Test
    public void testIFileToRootXmlResource() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        IProject project = this.project();
        IFile xmlFile = project.getFile("file.xml");
        xmlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        RootXmlResource xmlFileResource = (RootXmlResource)service.convert((Object)xmlFile, RootXmlResource.class);
        ConversionTests.assertNotNull((Object)xmlFileResource);
        IFile txtFile = project.getFile("file.txt");
        txtFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        RootXmlResource txtFileStore = (RootXmlResource)service.convert((Object)txtFile, RootXmlResource.class);
        ConversionTests.assertNull((Object)txtFileStore);
    }

    @Test
    public void testIFileToXmlResource() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        IProject project = this.project();
        IFile xmlFile = project.getFile("file.xml");
        xmlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        XmlResource xmlFileResource = (XmlResource)service.convert((Object)xmlFile, XmlResource.class);
        ConversionTests.assertNotNull((Object)xmlFileResource);
        IFile txtFile = project.getFile("file.txt");
        txtFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        XmlResource txtFileStore = (XmlResource)service.convert((Object)txtFile, XmlResource.class);
        ConversionTests.assertNull((Object)txtFileStore);
    }

    @Test
    public void testIFileToResource() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        IProject project = this.project();
        IFile xmlFile = project.getFile("file.xml");
        xmlFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        Resource xmlFileResource = (Resource)service.convert((Object)xmlFile, Resource.class);
        ConversionTests.assertNotNull((Object)xmlFileResource);
        IFile txtFile = project.getFile("file.txt");
        txtFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        Resource txtFileStore = (Resource)service.convert((Object)txtFile, Resource.class);
        ConversionTests.assertNull((Object)txtFileStore);
    }

    @Test
    public void testModelElementToDomDocument() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        XmlResourceStore xmlResourceStore = new XmlResourceStore();
        RootXmlResource xmlResource = new RootXmlResource(xmlResourceStore);
        XmlConversionTestElement elementOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate((Resource)xmlResource);
        Document document = (Document)service.convert((Object)elementOnXml, Document.class);
        ConversionTests.assertNotNull((Object)document);
        ConversionTests.assertSame((Object)document, (Object)xmlResource.getDomDocument());
        ConversionTests.assertSame((Object)document, (Object)elementOnXml.adapt(Document.class));
        ConversionTests.assertSame((Object)document, (Object)((XmlConversionTestElement.ListEntry)elementOnXml.getList().insert()).adapt(Document.class));
        XmlConversionTestElement elementNotOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate();
        ConversionTests.assertNull((Object)service.convert((Object)elementNotOnXml, Document.class));
        ConversionTests.assertNull((Object)service.convert((Object)elementNotOnXml.getList().insert(), Document.class));
    }

    @Test
    public void testModelElementToDomElement() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        XmlResourceStore xmlResourceStore = new XmlResourceStore();
        RootXmlResource xmlResource = new RootXmlResource(xmlResourceStore);
        XmlConversionTestElement elementOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate((Resource)xmlResource);
        xmlResource.save();
        Element xmlElement = (Element)service.convert((Object)elementOnXml, Element.class);
        ConversionTests.assertNotNull((Object)xmlElement);
        ConversionTests.assertSame((Object)xmlElement, (Object)xmlResource.getXmlElement().getDomNode());
        ConversionTests.assertSame((Object)xmlElement, (Object)elementOnXml.adapt(Element.class));
        XmlConversionTestElement.ListEntry childElement = (XmlConversionTestElement.ListEntry)elementOnXml.getList().insert();
        Element childXmlElement = (Element)service.convert((Object)childElement, Element.class);
        ConversionTests.assertNotNull((Object)childXmlElement);
        ConversionTests.assertSame((Object)childXmlElement, (Object)((XmlResource)childElement.resource()).getXmlElement().getDomNode());
        ConversionTests.assertSame((Object)childXmlElement, (Object)childElement.adapt(Element.class));
        ConversionTests.assertNotSame((Object)childXmlElement, (Object)xmlElement);
        XmlConversionTestElement elementNotOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate();
        ConversionTests.assertNull((Object)service.convert((Object)elementNotOnXml, Element.class));
        ConversionTests.assertNull((Object)service.convert((Object)elementNotOnXml.getList().insert(), Element.class));
    }

    @Test
    public void testModelElementToXmlElement() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        XmlResourceStore xmlResourceStore = new XmlResourceStore();
        RootXmlResource xmlResource = new RootXmlResource(xmlResourceStore);
        XmlConversionTestElement elementOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate((Resource)xmlResource);
        xmlResource.save();
        XmlElement xmlElement = (XmlElement)service.convert((Object)elementOnXml, XmlElement.class);
        ConversionTests.assertNotNull((Object)xmlElement);
        ConversionTests.assertSame((Object)xmlElement, (Object)xmlResource.getXmlElement());
        ConversionTests.assertSame((Object)xmlElement, (Object)elementOnXml.adapt(XmlElement.class));
        XmlConversionTestElement.ListEntry childElement = (XmlConversionTestElement.ListEntry)elementOnXml.getList().insert();
        XmlElement childXmlElement = (XmlElement)service.convert((Object)childElement, XmlElement.class);
        ConversionTests.assertNotNull((Object)childXmlElement);
        ConversionTests.assertSame((Object)childXmlElement, (Object)((XmlResource)childElement.resource()).getXmlElement());
        ConversionTests.assertSame((Object)childXmlElement, (Object)childElement.adapt(XmlElement.class));
        ConversionTests.assertNotSame((Object)childXmlElement, (Object)xmlElement);
        XmlConversionTestElement elementNotOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate();
        ConversionTests.assertNull((Object)service.convert((Object)elementNotOnXml, XmlElement.class));
        ConversionTests.assertNull((Object)service.convert((Object)elementNotOnXml.getList().insert(), XmlElement.class));
    }

    @Test
    public void testXmlResourceToDomDocument() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        XmlResourceStore xmlResourceStore = new XmlResourceStore();
        RootXmlResource xmlResource = new RootXmlResource(xmlResourceStore);
        Document document = (Document)service.convert((Object)xmlResource, Document.class);
        ConversionTests.assertNotNull((Object)document);
        ConversionTests.assertSame((Object)document, (Object)xmlResource.getDomDocument());
        ConversionTests.assertSame((Object)document, (Object)xmlResource.adapt(Document.class));
    }

    @Test
    public void testXmlResourceToDomElement() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        XmlResourceStore xmlResourceStore = new XmlResourceStore();
        RootXmlResource xmlResource = new RootXmlResource(xmlResourceStore);
        XmlConversionTestElement elementOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate((Resource)xmlResource);
        xmlResource.save();
        Element xmlElement = (Element)service.convert((Object)xmlResource, Element.class);
        ConversionTests.assertNotNull((Object)xmlElement);
        ConversionTests.assertSame((Object)xmlElement, (Object)xmlResource.getXmlElement().getDomNode());
        ConversionTests.assertSame((Object)xmlElement, (Object)xmlResource.adapt(Element.class));
        XmlConversionTestElement.ListEntry childElement = (XmlConversionTestElement.ListEntry)elementOnXml.getList().insert();
        Element childXmlElement = (Element)service.convert((Object)childElement.resource(), Element.class);
        XmlResource childXmlResource = (XmlResource)childElement.resource();
        ConversionTests.assertNotNull((Object)childXmlElement);
        ConversionTests.assertSame((Object)childXmlElement, (Object)childXmlResource.getXmlElement().getDomNode());
        ConversionTests.assertSame((Object)childXmlElement, (Object)childXmlResource.adapt(Element.class));
        ConversionTests.assertNotSame((Object)childXmlElement, (Object)xmlElement);
    }

    @Test
    public void testXmlResourceToXmlElement() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        XmlResourceStore xmlResourceStore = new XmlResourceStore();
        RootXmlResource xmlResource = new RootXmlResource(xmlResourceStore);
        XmlConversionTestElement elementOnXml = (XmlConversionTestElement)XmlConversionTestElement.TYPE.instantiate((Resource)xmlResource);
        xmlResource.save();
        XmlElement xmlElement = (XmlElement)service.convert((Object)xmlResource, XmlElement.class);
        ConversionTests.assertNotNull((Object)xmlElement);
        ConversionTests.assertSame((Object)xmlElement, (Object)xmlResource.getXmlElement());
        ConversionTests.assertSame((Object)xmlElement, (Object)xmlResource.adapt(XmlElement.class));
        XmlConversionTestElement.ListEntry childElement = (XmlConversionTestElement.ListEntry)elementOnXml.getList().insert();
        XmlElement childXmlElement = (XmlElement)service.convert((Object)childElement.resource(), XmlElement.class);
        XmlResource childXmlResource = (XmlResource)childElement.resource();
        ConversionTests.assertNotNull((Object)childXmlElement);
        ConversionTests.assertSame((Object)childXmlElement, (Object)childXmlResource.getXmlElement());
        ConversionTests.assertSame((Object)childXmlElement, (Object)childXmlResource.adapt(XmlElement.class));
        ConversionTests.assertNotSame((Object)childXmlElement, (Object)xmlElement);
    }

    @Test
    public void testStringToJavaIdentifier() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        ConversionTests.assertEquals((Object)new JavaIdentifier("_"), (Object)service.convert((Object)"_", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("$"), (Object)service.convert((Object)"$", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("a"), (Object)service.convert((Object)"a", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("_abc"), (Object)service.convert((Object)"_abc", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("$abc"), (Object)service.convert((Object)"$abc", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("aabc"), (Object)service.convert((Object)"aabc", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("AbC_"), (Object)service.convert((Object)"AbC_", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("AbC$"), (Object)service.convert((Object)"AbC$", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("AbCa"), (Object)service.convert((Object)"AbCa", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("AbC1"), (Object)service.convert((Object)"AbC1", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("abc123"), (Object)service.convert((Object)"abc123", JavaIdentifier.class));
        ConversionTests.assertEquals((Object)new JavaIdentifier("abc$_123"), (Object)service.convert((Object)"abc$_123", JavaIdentifier.class));
        ConversionTests.assertNull((Object)service.convert((Object)"1", JavaIdentifier.class));
        ConversionTests.assertNull((Object)service.convert((Object)"1abc", JavaIdentifier.class));
        ConversionTests.assertNull((Object)service.convert((Object)"ab#c", JavaIdentifier.class));
        ConversionTests.assertNull((Object)service.convert((Object)"ab.c", JavaIdentifier.class));
    }
}

