/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.misc.t0002;

import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.junit.Test;

public final class TestMisc0002
extends SapphireTestCase {
    @Test
    public void testVersionFromString_Basic() {
        Version version = new Version("1");
        TestMisc0002.assertEquals((long)1L, (long)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals(TestMisc0002.list(1L), (Object)version.segments());
        version = new Version("1.2");
        TestMisc0002.assertEquals((long)2L, (long)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L), (Object)version.segments());
        version = new Version("1.2.3");
        TestMisc0002.assertEquals((long)3L, (long)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L), (Object)version.segments());
    }

    @Test
    public void testVersionFromString_LongSegment() {
        Version version = new Version("1.2.3.201206260957");
        TestMisc0002.assertEquals((long)4L, (long)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals((long)201206260957L, (long)version.segment(3));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L, 201206260957L), (Object)version.segments());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_1() {
        new Version(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_2() {
        new Version("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_3() {
        new Version(".1.2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_4() {
        new Version("1.2.3.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_5() {
        new Version("1..2.3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_6() {
        new Version("abc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_7() {
        new Version("1.2.abc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_8() {
        new Version("1.2.v345");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVersionFromString_InvalidFormat_9() {
        new Version("1.2.345abc");
    }

    @Test
    public void testVersionFromLong() {
        Version version = new Version(1L);
        TestMisc0002.assertEquals((long)1L, (long)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals(TestMisc0002.list(1L), (Object)version.segments());
        version = new Version(201206260957L);
        TestMisc0002.assertEquals((long)1L, (long)version.length());
        TestMisc0002.assertEquals((long)201206260957L, (long)version.segment(0));
        TestMisc0002.assertEquals(TestMisc0002.list(201206260957L), (Object)version.segments());
    }

    @Test
    public void testVersionCanonicalization() {
        Version version = new Version("1.2.3.0");
        TestMisc0002.assertEquals((long)3L, (long)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(3));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(1000));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L), (Object)version.segments());
        version = new Version("1.2.3.0.0.0.0");
        TestMisc0002.assertEquals((long)3L, (long)version.length());
        TestMisc0002.assertEquals((long)1L, (long)version.segment(0));
        TestMisc0002.assertEquals((long)2L, (long)version.segment(1));
        TestMisc0002.assertEquals((long)3L, (long)version.segment(2));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(3));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(4));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(5));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(6));
        TestMisc0002.assertEquals((long)0L, (long)version.segment(1000));
        TestMisc0002.assertEquals(TestMisc0002.list(1L, 2L, 3L), (Object)version.segments());
    }

    @Test
    public void testVersionComparison() {
        this.testVersionComparisonSame(new Version(1L), new Version("1"));
        this.testVersionComparisonSame(new Version("1.2.3"), new Version("1.2.3"));
        this.testVersionComparisonSame(new Version("1.2.3"), new Version("1.2.3.0.0"));
        this.testVersionComparisonDifferent(new Version("1.2.4"), new Version("1.2.3"));
        this.testVersionComparisonDifferent(new Version("1.3.3"), new Version("1.2.3"));
        this.testVersionComparisonDifferent(new Version("2.2.3"), new Version("1.2.3"));
        this.testVersionComparisonDifferent(new Version("1.2.3"), new Version("1.2"));
        this.testVersionComparisonDifferent(new Version("1.2.3"), new Version("1"));
        this.testVersionComparisonDifferent(new Version("1.2.3"), new Version(1L));
    }

    private void testVersionComparisonSame(Version x, Version y) {
        TestMisc0002.assertTrue((x.compareTo(y) == 0 ? 1 : 0) != 0);
        TestMisc0002.assertTrue((y.compareTo(x) == 0 ? 1 : 0) != 0);
    }

    private void testVersionComparisonDifferent(Version x, Version y) {
        TestMisc0002.assertTrue((x.compareTo(y) > 0 ? 1 : 0) != 0);
        TestMisc0002.assertTrue((y.compareTo(x) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersionEquals() {
        this.testVersionEquals(new Version(1L), new Version("1"));
        this.testVersionEquals(new Version("1.2.3"), new Version("1.2.3"));
        this.testVersionEquals(new Version("1.2.3"), new Version("1.2.3.0.0"));
        this.testVersionNotEquals(new Version("1.2.3"), new Version("1.2"));
        this.testVersionNotEquals(new Version("1.2.3"), new Version("4.5.6"));
    }

    private void testVersionEquals(Version x, Version y) {
        TestMisc0002.assertTrue((boolean)x.equals((Object)y));
        TestMisc0002.assertTrue((boolean)y.equals((Object)x));
        TestMisc0002.assertTrue((x.hashCode() == y.hashCode() ? 1 : 0) != 0);
    }

    private void testVersionNotEquals(Version x, Version y) {
        TestMisc0002.assertFalse((boolean)x.equals((Object)y));
        TestMisc0002.assertFalse((boolean)y.equals((Object)x));
    }

    @Test
    public void testVersionToString() {
        TestMisc0002.assertEquals((Object)"1", (Object)new Version(1L).toString());
        TestMisc0002.assertEquals((Object)"1", (Object)new Version("1").toString());
        TestMisc0002.assertEquals((Object)"1.2.3", (Object)new Version("1.2.3").toString());
        TestMisc0002.assertEquals((Object)"1.2.3.201206260957", (Object)new Version("1.2.3.201206260957").toString());
        TestMisc0002.assertEquals((Object)"1.2.3", (Object)new Version("1.2.3.0").toString());
        TestMisc0002.assertEquals((Object)"1.2.3", (Object)new Version("1.2.3.0.0.0.0").toString());
    }
}

