/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.ConnectionService;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;

public class DiagramDeleteActionHandler
extends SapphireActionHandler {
    @Override
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        ISapphirePart part = this.getPart();
        if (part instanceof SapphireDiagramEditorPagePart) {
            ((SapphireDiagramEditorPagePart)part).attach((Listener)new FilteredListener<SapphireEditorPagePart.SelectionChangedEvent>(){

                protected void handleTypedEvent(SapphireEditorPagePart.SelectionChangedEvent event) {
                    DiagramDeleteActionHandler.this.refreshEnablement();
                }
            });
        }
        this.refreshEnablement();
    }

    private void refreshEnablement() {
        ISapphirePart part = this.getPart();
        boolean enabled = false;
        if (part instanceof DiagramNodePart || part instanceof ShapePart || part instanceof DiagramConnectionPart && ((DiagramConnectionPart)part).removable()) {
            enabled = true;
        } else {
            SapphireDiagramEditorPagePart diagramPart = part.nearest(SapphireDiagramEditorPagePart.class);
            List<ISapphirePart> selectedParts = diagramPart.getSelections();
            for (ISapphirePart selectedPart : selectedParts) {
                if (!(selectedPart instanceof DiagramNodePart) && !(selectedPart instanceof ShapePart) && (!(selectedPart instanceof DiagramConnectionPart) || !((DiagramConnectionPart)selectedPart).removable())) continue;
                enabled = true;
            }
        }
        this.setEnabled(enabled);
    }

    @Override
    protected Object run(Presentation context) {
        SapphirePart part = context.part();
        if (part instanceof DiagramConnectionPart) {
            DiagramConnectionPart connPart = (DiagramConnectionPart)part;
            connPart.remove();
        } else if (part instanceof DiagramNodePart) {
            DiagramNodePart nodePart = (DiagramNodePart)part;
            this.deleteNode(nodePart);
        } else if (part instanceof ShapePart) {
            ShapePart shapePart = (ShapePart)part;
            this.deleteShapePart(shapePart);
        } else if (part instanceof SapphireDiagramEditorPagePart) {
            SapphireDiagramEditorPagePart pagePart = (SapphireDiagramEditorPagePart)part;
            ArrayList<ISapphirePart> parts = new ArrayList<ISapphirePart>();
            parts.addAll(pagePart.getSelections());
            for (ISapphirePart selectedPart : parts) {
                if (selectedPart instanceof DiagramConnectionPart) {
                    DiagramConnectionPart connPart = (DiagramConnectionPart)selectedPart;
                    connPart.remove();
                    continue;
                }
                if (selectedPart instanceof DiagramNodePart) {
                    DiagramNodePart nodePart = (DiagramNodePart)selectedPart;
                    this.deleteNode(nodePart);
                    continue;
                }
                if (!(selectedPart instanceof ShapePart)) continue;
                ShapePart shapePart = (ShapePart)selectedPart;
                this.deleteShapePart(shapePart);
            }
        }
        return null;
    }

    private void deleteNodeConnections(DiagramNodePart nodePart) {
        Element nodeElement = nodePart.getLocalModelElement();
        SapphireDiagramEditorPagePart diagramPart = nodePart.getDiagramNodeTemplate().getDiagramEditorPart();
        ConnectionService connService = diagramPart.service(ConnectionService.class);
        for (DiagramConnectionPart connPart : connService.list()) {
            if (!connPart.removable() || (connPart.getEndpoint1() == null || connPart.getEndpoint1() != nodeElement) && (connPart.getEndpoint2() == null || connPart.getEndpoint2() != nodeElement)) continue;
            connPart.remove();
        }
    }

    private void deleteNode(DiagramNodePart nodePart) {
        this.deleteNodeConnections(nodePart);
        nodePart.getDiagramNodeTemplate().deleteNode(nodePart);
    }

    private void deleteShapePart(ShapePart shapePart) {
        Element shapeModel = shapePart.getLocalModelElement();
        ElementList list = (ElementList)shapeModel.parent();
        if (!list.disposed()) {
            list.remove((Object)shapeModel);
        }
    }
}

