/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.po;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Length;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Serialization;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionCompatibilityTarget;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.samples.po.BillingInformation;
import org.eclipse.sapphire.samples.po.CashPayment;
import org.eclipse.sapphire.samples.po.CheckPayment;
import org.eclipse.sapphire.samples.po.CreditCardPayment;
import org.eclipse.sapphire.samples.po.Payment;
import org.eclipse.sapphire.samples.po.PurchaseOrderEntry;
import org.eclipse.sapphire.samples.po.PurchaseOrderResourceConversionService;
import org.eclipse.sapphire.samples.po.ShippingInformation;

@Service(impl=PurchaseOrderResourceConversionService.class)
@VersionCompatibilityTarget(version="${ Version }", versioned="Purchase Order")
public interface PurchaseOrder
extends Element {
    public static final ElementType TYPE = new ElementType(PurchaseOrder.class);
    @Type(base=Version.class)
    @DefaultValue(text="2.0")
    public static final ValueProperty PROP_VERSION = new ValueProperty(TYPE, "Version");
    @Label(standard="ID")
    @Required
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, "Id");
    @Label(standard="customer")
    @Required
    public static final ValueProperty PROP_CUSTOMER = new ValueProperty(TYPE, "Customer");
    @Type(base=Date.class)
    @Label(standard="initial quote date")
    @Serialization(primary="yyyy-MM-dd", alternative={"MM/dd/yyyy"})
    @Since(value="1.5")
    public static final ValueProperty PROP_INITIAL_QUOTE_DATE = new ValueProperty(TYPE, "InitialQuoteDate");
    @Type(base=Date.class)
    @Label(standard="order date")
    @Serialization(primary="yyyy-MM-dd", alternative={"MM/dd/yyyy"})
    public static final ValueProperty PROP_ORDER_DATE = new ValueProperty(TYPE, "OrderDate");
    @Type(base=Date.class)
    @Label(standard="fulfillment date")
    @Serialization(primary="yyyy-MM-dd", alternative={"MM/dd/yyyy"})
    @Since(value="2.0")
    public static final ValueProperty PROP_FULFILLMENT_DATE = new ValueProperty(TYPE, "FulfillmentDate");
    @Type(base=BillingInformation.class)
    @Label(standard="billing information")
    public static final ImpliedElementProperty PROP_BILLING_INFORMATION = new ImpliedElementProperty(TYPE, "BillingInformation");
    @Type(base=ShippingInformation.class)
    @Label(standard="shipping information")
    @Since(value="2.0")
    public static final ImpliedElementProperty PROP_SHIPPING_INFORMATION = new ImpliedElementProperty(TYPE, "ShippingInformation");
    @Type(base=Payment.class, possible={CreditCardPayment.class, CheckPayment.class, CashPayment.class})
    @Label(standard="payment")
    @Since(value="1.5")
    public static final ElementProperty PROP_PAYMENT = new ElementProperty(TYPE, "Payment");
    @Type(base=PurchaseOrderEntry.class)
    @Label(standard="entries")
    @Length(min=1)
    public static final ListProperty PROP_ENTRIES = new ListProperty(TYPE, "Entries");
    @Type(base=BigDecimal.class)
    @Label(standard="subtotal")
    @Derived(text="${ Sum( Entries, 'Total' ) }")
    public static final ValueProperty PROP_SUBTOTAL = new ValueProperty(TYPE, "Subtotal");
    @Type(base=BigDecimal.class)
    @Label(standard="discount")
    @DefaultValue(text="0.00")
    @Validation(rule="${ Scale( Discount, 2 ) <= Scale( Subtotal, 2 ) + Scale( Delivery, 2 ) }", message="Discount must not exceed subtotal plus delivery charge")
    public static final ValueProperty PROP_DISCOUNT = new ValueProperty(TYPE, "Discount");
    @Type(base=BigDecimal.class)
    @Label(standard="delivery")
    @DefaultValue(text="0.00")
    @NumericRange(min="0")
    public static final ValueProperty PROP_DELIVERY = new ValueProperty(TYPE, "Delivery");
    @Type(base=BigDecimal.class)
    @Label(standard="total")
    @Derived(text="${ Scale( Subtotal, 2 ) - Scale( Discount, 2 ) + Scale( Delivery, 2 ) }")
    public static final ValueProperty PROP_TOTAL = new ValueProperty(TYPE, "Total");

    public Value<Version> getVersion();

    public void setVersion(String var1);

    public void setVersion(Version var1);

    public Value<String> getId();

    public void setId(String var1);

    public Value<String> getCustomer();

    public void setCustomer(String var1);

    public Value<Date> getInitialQuoteDate();

    public void setInitialQuoteDate(String var1);

    public void setInitialQuoteDate(Date var1);

    public Value<Date> getOrderDate();

    public void setOrderDate(String var1);

    public void setOrderDate(Date var1);

    public Value<Date> getFulfillmentDate();

    public void setFulfillmentDate(String var1);

    public void setFulfillmentDate(Date var1);

    public BillingInformation getBillingInformation();

    public ShippingInformation getShippingInformation();

    public ElementHandle<Payment> getPayment();

    public ElementList<PurchaseOrderEntry> getEntries();

    public Value<BigDecimal> getSubtotal();

    public Value<BigDecimal> getDiscount();

    public void setDiscount(String var1);

    public void setDiscount(BigDecimal var1);

    public Value<BigDecimal> getDelivery();

    public void setDelivery(String var1);

    public void setDelivery(BigDecimal var1);

    public Value<BigDecimal> getTotal();
}

