/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.length;

import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.services.FactsAggregationService;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.length.TestElement;
import org.junit.Test;

public final class LengthConstraintTests
extends SapphireTestCase {
    private static final String TEN = "1234567890";
    private static final String FIFTY = "12345678901234567890123456789012345678901234567890";
    private static final String HUNDRED = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
    private static final String LONG = "Sapphire aims to raise UI writing to a higher level of abstraction. The core premise is that the basic building block of UI should not be a widget (text box, label, button, etc.), but rather a property editor. Unlike a widget, a property editor analyzes metadata associated with a given property, renders the appropriate widgets to edit that property and wires up data binding. Data is synchronized, validation is passed from the model to the UI, content assistance is made available, etc.";

    @Test
    public void FactsMinValue() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertEquals(LengthConstraintTests.set("Minimum length is 8"), (Object)((FactsAggregationService)element.getMinValue().service(FactsAggregationService.class)).facts());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void FactsMaxValue() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertEquals(LengthConstraintTests.set("Maximum length is 50"), (Object)((FactsAggregationService)element.getMaxValue().service(FactsAggregationService.class)).facts());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void FactsMinMaxValue() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertEquals(LengthConstraintTests.set("Minimum length is 17", "Maximum length is 297"), (Object)((FactsAggregationService)element.getMinMaxValue().service(FactsAggregationService.class)).facts());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void FactsMinOneList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertEquals(LengthConstraintTests.set("Must have at least one"), (Object)((FactsAggregationService)element.getMinOneList().service(FactsAggregationService.class)).facts());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void FactsMinTwoList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertEquals(LengthConstraintTests.set("Must have at least 2 items"), (Object)((FactsAggregationService)element.getMinTwoList().service(FactsAggregationService.class)).facts());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void FactsMaxList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertEquals(LengthConstraintTests.set("Must have at most 12 items"), (Object)((FactsAggregationService)element.getMaxList().service(FactsAggregationService.class)).facts());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void FactsMinMaxList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertEquals(LengthConstraintTests.set("Must have at least one", "Must have at most 15 items"), (Object)((FactsAggregationService)element.getMinMaxList().service(FactsAggregationService.class)).facts());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void ValidationMinValue() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertValidationOk(element.getMinValue());
            element.setMinValue("abc");
            LengthConstraintTests.assertValidationError(element.getMinValue(), "Minimum length is 8");
            element.setMinValue("1234567");
            LengthConstraintTests.assertValidationError(element.getMinValue(), "Minimum length is 8");
            element.setMinValue("12345678");
            LengthConstraintTests.assertValidationOk(element.getMinValue());
            element.setMinValue(LONG);
            LengthConstraintTests.assertValidationOk(element.getMinValue());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void ValidationMaxValue() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertValidationOk(element.getMaxValue());
            element.setMaxValue("abc");
            LengthConstraintTests.assertValidationOk(element.getMaxValue());
            element.setMaxValue(FIFTY);
            LengthConstraintTests.assertValidationOk(element.getMaxValue());
            element.setMaxValue("123456789012345678901234567890123456789012345678901");
            LengthConstraintTests.assertValidationError(element.getMaxValue(), "Maximum length is 50");
            element.setMaxValue(LONG);
            LengthConstraintTests.assertValidationError(element.getMaxValue(), "Maximum length is 50");
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void ValidationMinMaxValue() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertValidationOk(element.getMinMaxValue());
            element.setMinMaxValue("abc");
            LengthConstraintTests.assertValidationError(element.getMinMaxValue(), "Minimum length is 17");
            element.setMinMaxValue("1234567890123456");
            LengthConstraintTests.assertValidationError(element.getMinMaxValue(), "Minimum length is 17");
            element.setMinMaxValue("12345678901234567");
            LengthConstraintTests.assertValidationOk(element.getMinMaxValue());
            element.setMinMaxValue(HUNDRED);
            LengthConstraintTests.assertValidationOk(element.getMinMaxValue());
            element.setMinMaxValue("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567");
            LengthConstraintTests.assertValidationOk(element.getMinMaxValue());
            element.setMinMaxValue("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678");
            LengthConstraintTests.assertValidationError(element.getMinMaxValue(), "Maximum length is 297");
            element.setMinMaxValue(LONG);
            LengthConstraintTests.assertValidationError(element.getMinMaxValue(), "Maximum length is 297");
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void ValidationMinOneList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertValidationError(element.getMinOneList(), "Must have at least one");
            LengthConstraintTests.add(element.getMinOneList(), 1);
            LengthConstraintTests.assertValidationOk(element.getMinOneList());
            LengthConstraintTests.add(element.getMinOneList(), 23);
            LengthConstraintTests.assertValidationOk(element.getMinOneList());
            element.getMinOneList().clear();
            LengthConstraintTests.assertValidationError(element.getMinOneList(), "Must have at least one");
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void ValidationMinTwoList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertValidationError(element.getMinTwoList(), "Must have at least 2 items");
            LengthConstraintTests.add(element.getMinTwoList(), 1);
            LengthConstraintTests.assertValidationError(element.getMinTwoList(), "Must have at least 2 items");
            LengthConstraintTests.add(element.getMinTwoList(), 1);
            LengthConstraintTests.assertValidationOk(element.getMinTwoList());
            LengthConstraintTests.add(element.getMinTwoList(), 23);
            LengthConstraintTests.assertValidationOk(element.getMinTwoList());
            element.getMinTwoList().clear();
            LengthConstraintTests.assertValidationError(element.getMinTwoList(), "Must have at least 2 items");
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void ValidationMaxList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertValidationOk(element.getMaxList());
            LengthConstraintTests.add(element.getMaxList(), 3);
            LengthConstraintTests.assertValidationOk(element.getMaxList());
            LengthConstraintTests.add(element.getMaxList(), 9);
            LengthConstraintTests.assertValidationOk(element.getMaxList());
            LengthConstraintTests.add(element.getMaxList(), 1);
            LengthConstraintTests.assertValidationError(element.getMaxList(), "Must have at most 12 items");
            LengthConstraintTests.add(element.getMaxList(), 57);
            LengthConstraintTests.assertValidationError(element.getMaxList(), "Must have at most 12 items");
            element.getMaxList().clear();
            LengthConstraintTests.assertValidationOk(element.getMaxList());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void ValidationMinMaxList() throws Exception {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            LengthConstraintTests.assertValidationError(element.getMinMaxList(), "Must have at least one");
            LengthConstraintTests.add(element.getMinMaxList(), 1);
            LengthConstraintTests.assertValidationOk(element.getMinMaxList());
            LengthConstraintTests.add(element.getMinMaxList(), 3);
            LengthConstraintTests.assertValidationOk(element.getMinMaxList());
            LengthConstraintTests.add(element.getMinMaxList(), 11);
            LengthConstraintTests.assertValidationOk(element.getMinMaxList());
            LengthConstraintTests.add(element.getMinMaxList(), 1);
            LengthConstraintTests.assertValidationError(element.getMinMaxList(), "Must have at most 15 items");
            LengthConstraintTests.add(element.getMinMaxList(), 57);
            LengthConstraintTests.assertValidationError(element.getMinMaxList(), "Must have at most 15 items");
            element.getMinMaxList().clear();
            LengthConstraintTests.assertValidationError(element.getMinMaxList(), "Must have at least one");
        }
        finally {
            element.dispose();
        }
    }

    private static void add(ElementList<?> list, int items) {
        int i = 0;
        while (i < items) {
            list.insert();
            ++i;
        }
    }
}

