/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.ValidationService;

public abstract class PathValidationService
extends ValidationService {
    @Text(value="Folder \"{0}\" does not exist")
    protected static LocalizableText folderMustExist;
    @Text(value="File \"{0}\" does not exist")
    protected static LocalizableText fileMustExist;
    @Text(value="File or folder \"{0}\" does not exist")
    protected static LocalizableText resourceMustExistMessage;
    @Text(value="Resource at location \"{0}\" is not a file")
    protected static LocalizableText pathIsNotFile;
    @Text(value="Resource at location \"{0}\" is not a folder")
    protected static LocalizableText pathIsNotFolder;
    @Text(value="File \"{0}\" has an invalid extension. Only \"{1}\" extension is allowed")
    protected static LocalizableText invalidFileExtensionOne;
    @Text(value="File \"{0}\" has an invalid extension. Only extensions \"{1}\" and \"{2}\" are allowed")
    protected static LocalizableText invalidFileExtensionTwo;
    @Text(value="File \"{0}\" has an invalid extension. Only extensions from \"{1}\" list are allowed")
    protected static LocalizableText invalidFileExtensionMultiple;
    protected boolean resourceMustExist;
    protected FileSystemResourceType validResourceType;
    private FileExtensionsService fileExtensionsService;

    static {
        LocalizableText.init(PathValidationService.class);
    }

    @Override
    protected void initValidationService() {
        Property property = this.context(Property.class);
        this.resourceMustExist = property.definition().hasAnnotation(MustExist.class);
        ValidFileSystemResourceType validResourceTypeAnnotation = property.definition().getAnnotation(ValidFileSystemResourceType.class);
        this.validResourceType = validResourceTypeAnnotation != null ? validResourceTypeAnnotation.value() : null;
        this.fileExtensionsService = property.service(FileExtensionsService.class);
        if (this.fileExtensionsService != null) {
            this.fileExtensionsService.attach(new Listener(){

                @Override
                public void handle(Event event) {
                    PathValidationService.this.refresh();
                }
            });
        }
    }

    protected final Status validateExtensions(Path path) {
        String fileName;
        if (this.fileExtensionsService != null && (fileName = path.lastSegment()) != null) {
            int count;
            List<String> extensions = this.fileExtensionsService.extensions();
            int n = count = extensions == null ? 0 : extensions.size();
            if (count > 0) {
                String trimmedFileName = fileName.trim();
                int lastdot = trimmedFileName.lastIndexOf(46);
                String extension = lastdot == -1 ? "" : trimmedFileName.substring(lastdot + 1);
                boolean match = false;
                if (extension != null && extension.length() != 0) {
                    for (String ext : extensions) {
                        if (!extension.equalsIgnoreCase(ext)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match) {
                    String message;
                    if (count == 1) {
                        message = invalidFileExtensionOne.format(trimmedFileName, extensions.get(0));
                    } else if (count == 2) {
                        message = invalidFileExtensionTwo.format(trimmedFileName, extensions.get(0), extensions.get(1));
                    } else {
                        StringBuilder buf = new StringBuilder();
                        for (String ext : extensions) {
                            if (buf.length() != 0) {
                                buf.append(", ");
                            }
                            buf.append(ext);
                        }
                        message = invalidFileExtensionMultiple.format(trimmedFileName, buf.toString());
                    }
                    return Status.createErrorStatus(message);
                }
            }
        }
        return Status.createOkStatus();
    }
}

