/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.HashSet;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.services.DependenciesService;
import org.eclipse.sapphire.services.DependenciesServiceData;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DeclarativeDependenciesService
extends DependenciesService {
    @Override
    protected DependenciesServiceData compute() {
        HashSet<String> dependenciesAsStrings = new HashSet<String>();
        DependsOn dependsOnAnnotation = this.context(PropertyDef.class).getAnnotation(DependsOn.class);
        if (dependsOnAnnotation != null) {
            String[] stringArray = dependsOnAnnotation.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dependsOnPropertyRef = stringArray[n2];
                dependenciesAsStrings.add(dependsOnPropertyRef);
                ++n2;
            }
        }
        HashSet<ModelPath> dependencies = new HashSet<ModelPath>();
        for (String str : dependenciesAsStrings) {
            ModelPath path = null;
            try {
                path = new ModelPath(str);
            }
            catch (ModelPath.MalformedPathException e) {
                Sapphire.service(LoggingService.class).log(e);
            }
            dependencies.add(path);
        }
        return new DependenciesServiceData(dependencies);
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            return context.find(PropertyDef.class).hasAnnotation(DependsOn.class);
        }
    }
}

