/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.StandardLocalizationService;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.InvalidDefinitionException;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.forms.DialogDef;
import org.eclipse.sapphire.ui.forms.FormComponentDef;
import org.eclipse.sapphire.ui.forms.WizardDef;
import org.eclipse.sapphire.util.EqualsFactory;
import org.eclipse.sapphire.util.HashCodeFactory;

public final class DefinitionLoader {
    private static final Map<CacheKey, SoftReference<DefinitionLoader>> cache = new HashMap<CacheKey, SoftReference<DefinitionLoader>>();
    private final Context context;
    private ISapphireUiDef sdef;

    private DefinitionLoader(Context context) {
        this.context = context;
    }

    public static DefinitionLoader context(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        return new DefinitionLoader(context);
    }

    public static DefinitionLoader context(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        return DefinitionLoader.context(Context.adapt((ClassLoader)loader));
    }

    public static DefinitionLoader context(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        return DefinitionLoader.context(Context.adapt(cl));
    }

    public static DefinitionLoader sdef(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        return DefinitionLoader.context(cl).sdef(cl.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionLoader sdef(String name) {
        RootXmlResource resource;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.endsWith(".sdef") || name.contains("/")) {
            throw new IllegalArgumentException();
        }
        if (this.sdef != null) {
            throw new IllegalStateException();
        }
        CacheKey defLoaderCacheKey = new CacheKey(this.context, name);
        if (!Sapphire.isDevMode()) {
            Map<CacheKey, SoftReference<DefinitionLoader>> map = cache;
            synchronized (map) {
                DefinitionLoader loader;
                SoftReference<DefinitionLoader> defLoaderRef = cache.get(defLoaderCacheKey);
                if (defLoaderRef != null && (loader = defLoaderRef.get()) != null) {
                    return loader;
                }
            }
        }
        try {
            resource = new RootXmlResource(new XmlResourceStore((ByteArrayResourceStore)new DefinitionLoaderResourceStore(this.context, name)));
        }
        catch (ResourceStoreException e) {
            throw new IllegalArgumentException(e);
        }
        this.sdef = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate((Resource)resource);
        if (!Sapphire.isDevMode()) {
            Map<CacheKey, SoftReference<DefinitionLoader>> map = cache;
            synchronized (map) {
                cache.put(defLoaderCacheKey, new SoftReference<DefinitionLoader>(this));
            }
        }
        return this;
    }

    public Reference<ISapphireUiDef> root() {
        return new Reference<ISapphireUiDef>(this, this.sdef, null);
    }

    public Reference<EditorPageDef> page() {
        return this.page(null);
    }

    public Reference<EditorPageDef> page(String id) {
        EditorPageDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof EditorPageDef)) continue;
                def = (EditorPageDef)d;
                break;
            }
        } else {
            def = (EditorPageDef)this.sdef.getPartDef(id, true, EditorPageDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<EditorPageDef>(this, def, null);
    }

    public Reference<WizardDef> wizard() {
        return this.wizard(null);
    }

    public Reference<WizardDef> wizard(String id) {
        WizardDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof WizardDef)) continue;
                def = (WizardDef)d;
                break;
            }
        } else {
            def = (WizardDef)this.sdef.getPartDef(id, true, WizardDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<WizardDef>(this, def, null);
    }

    public Reference<DialogDef> dialog() {
        return this.dialog(null);
    }

    public Reference<DialogDef> dialog(String id) {
        DialogDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof DialogDef)) continue;
                def = (DialogDef)d;
                break;
            }
        } else {
            def = (DialogDef)this.sdef.getPartDef(id, true, DialogDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<DialogDef>(this, def, null);
    }

    public Reference<FormComponentDef> form() {
        return this.form(null);
    }

    public Reference<FormComponentDef> form(String id) {
        FormComponentDef def = null;
        if (id == null) {
            for (PartDef d : this.sdef.getPartDefs()) {
                if (!(d instanceof FormComponentDef)) continue;
                def = (FormComponentDef)d;
                break;
            }
        } else {
            def = (FormComponentDef)this.sdef.getPartDef(id, true, FormComponentDef.class);
        }
        if (def == null) {
            throw new IllegalArgumentException();
        }
        return new Reference<FormComponentDef>(this, def, null);
    }

    protected void finalize() {
        if (this.sdef != null) {
            this.sdef.dispose();
        }
    }

    private static final class CacheKey {
        private final Context context;
        private final String name;

        public CacheKey(Context context, String name) {
            this.context = context;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey key = (CacheKey)obj;
                return EqualsFactory.start().add((Object)this.context, (Object)key.context).add((Object)this.name, (Object)key.name).result();
            }
            return false;
        }

        public int hashCode() {
            return HashCodeFactory.start().add((Object)this.context).add((Object)this.name).result();
        }
    }

    private static final class DefinitionLoaderResourceStore
    extends ByteArrayResourceStore {
        private final Context context;
        private final String name;

        public DefinitionLoaderResourceStore(Context context, String name) throws ResourceStoreException {
            this.context = context;
            this.name = name.replace('.', '/');
            InputStream stream = null;
            try {
                stream = this.context.findResource(String.valueOf(this.name) + ".sdef");
                if (stream == null) {
                    throw new ResourceStoreException();
                }
                this.setContents(stream);
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }

        public <A> A adapt(Class<A> adapterType) {
            if (adapterType == Context.class) {
                return adapterType.cast(this.context);
            }
            return (A)super.adapt(adapterType);
        }

        protected LocalizationService initLocalizationService(Locale locale) {
            return new StandardLocalizationService(locale){

                protected boolean load(Locale locale, Map<String, String> keyToText) {
                    InputStream stream;
                    block11: {
                        boolean bl;
                        block12: {
                            String resFilePath = DefinitionLoaderResourceStore.this.name;
                            String localeString = locale.toString();
                            if (localeString.length() > 0) {
                                resFilePath = String.valueOf(resFilePath) + "_" + localeString;
                            }
                            resFilePath = String.valueOf(resFilePath) + ".properties";
                            stream = null;
                            try {
                                stream = DefinitionLoaderResourceStore.this.context.findResource(resFilePath);
                                if (stream == null) break block11;
                                bl = 1.parse((InputStream)stream, keyToText);
                                if (stream == null) break block12;
                            }
                            catch (Throwable throwable) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return bl;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return false;
                }
            };
        }
    }

    public static final class Reference<T extends Element>
    implements Disposable {
        private DefinitionLoader loader;
        private T def;

        private Reference(DefinitionLoader loader, T def) {
            if (loader == null) {
                throw new IllegalArgumentException();
            }
            if (def == null) {
                throw new IllegalArgumentException();
            }
            this.loader = loader;
            this.def = def;
        }

        public T resolve() {
            if (this.def == null) {
                throw new IllegalStateException();
            }
            Status validation = this.def.validation();
            if (validation.severity() == Status.Severity.ERROR) {
                throw new InvalidDefinitionException(validation);
            }
            return this.def;
        }

        public T resolveIgnoringValidation() {
            if (this.def == null) {
                throw new IllegalStateException();
            }
            return this.def;
        }

        public void dispose() {
            this.loader = null;
            this.def = null;
        }

        /* synthetic */ Reference(DefinitionLoader definitionLoader, Element element, Reference reference) {
            this(definitionLoader, element);
        }
    }
}

