/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.WizardDef;
import org.eclipse.sapphire.ui.forms.WizardPagePart;
import org.eclipse.sapphire.ui.forms.WizardPart;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.forms.swt.internal.ProgressMonitorBridge;
import org.eclipse.sapphire.ui.forms.swt.internal.StatusDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SapphireWizard<M extends Element>
implements IWizard,
Disposable {
    private Element element;
    private boolean elementInstantiatedLocally;
    private DefinitionLoader.Reference<WizardDef> definition;
    private WizardPart part;
    private Map<WizardPagePart, SapphireWizardPage> pages;
    private IWizardContainer container;
    private ImageDescriptor defaultPageImageDescriptor;
    private Image defaultPageImage;

    public SapphireWizard(ElementType type, DefinitionLoader.Reference<WizardDef> definition) {
        this.init(type, definition);
    }

    public SapphireWizard(M element, DefinitionLoader.Reference<WizardDef> definition) {
        this.init((Element)element, definition);
    }

    protected SapphireWizard() {
    }

    protected void init(ElementType type, DefinitionLoader.Reference<WizardDef> definition) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.elementInstantiatedLocally = true;
        this.init(type.instantiate(), definition);
    }

    protected void init(Element element, DefinitionLoader.Reference<WizardDef> definition) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.definition = definition;
        this.part = new WizardPart();
        this.part.init(null, this.element, this.definition.resolve(), Collections.<String, String>emptyMap());
        this.part.initialize();
        this.part.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    SapphireWizard.this.refreshImage();
                } else if (event instanceof SapphirePart.LabelChangedEvent) {
                    SapphireWizard.this.refreshTitle();
                }
            }
        });
        this.pages = new LinkedHashMap<WizardPagePart, SapphireWizardPage>();
        FilteredListener<PartVisibilityEvent> pageVisibilityListener = new FilteredListener<PartVisibilityEvent>(){

            protected void handleTypedEvent(PartVisibilityEvent event) {
                SapphireWizard.this.getContainer().updateButtons();
            }
        };
        for (WizardPagePart page : this.part.getPages()) {
            page.attach((Listener)pageVisibilityListener);
            this.pages.put(page, null);
        }
        this.refreshImage();
    }

    public final M element() {
        return (M)this.element;
    }

    public final WizardDef definition() {
        return this.definition == null ? null : this.definition.resolve();
    }

    public final WizardPart part() {
        return this.part;
    }

    public IWizardPage[] getPages() {
        ArrayList<SapphireWizardPage> result = new ArrayList<SapphireWizardPage>();
        for (WizardPagePart wizardPagePart : this.pages.keySet()) {
            if (!wizardPagePart.visible()) continue;
            SapphireWizardPage wizardPagePresentation = this.pages.get(wizardPagePart);
            if (wizardPagePresentation == null) {
                wizardPagePresentation = new SapphireWizardPage(wizardPagePart);
                wizardPagePresentation.setWizard(this);
                this.pages.put(wizardPagePart, wizardPagePresentation);
            }
            result.add(wizardPagePresentation);
        }
        return result.toArray(new IWizardPage[result.size()]);
    }

    public final int getPageCount() {
        return this.getPages().length;
    }

    public final IWizardPage getPage(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (name.equals(page.getName())) {
                return page;
            }
            ++n2;
        }
        return null;
    }

    public final IWizardPage getStartingPage() {
        IWizardPage[] pages = this.getPages();
        if (pages.length > 0) {
            return pages[0];
        }
        return null;
    }

    public final IWizardPage getNextPage(IWizardPage page) {
        boolean captureNextPage = false;
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage p = iWizardPageArray[n2];
            if (captureNextPage) {
                return p;
            }
            if (p == page) {
                captureNextPage = true;
            }
            ++n2;
        }
        return null;
    }

    public final IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage previous = null;
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage p = iWizardPageArray[n2];
            if (p == page) break;
            previous = p;
            ++n2;
        }
        return previous;
    }

    public final void addPages() {
    }

    public final boolean canFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage p = iWizardPageArray[n2];
            if (!p.isPageComplete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final boolean performFinish() {
        DelayedTasksExecutor.sweep();
        if (!this.canFinish()) {
            return false;
        }
        final Status[] result = new Status[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                result[0] = SapphireWizard.this.performFinish(ProgressMonitorBridge.create(monitor));
            }
        };
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        Status st = result[0];
        if (st.severity() == Status.Severity.ERROR) {
            return this.handleFinishFailure(st);
        }
        this.performPostFinish();
        return true;
    }

    protected Status performFinish(ProgressMonitor monitor) {
        if (this.element instanceof ExecutableElement) {
            return ((ExecutableElement)this.element).execute(monitor);
        }
        return Status.createOkStatus();
    }

    protected void performPostFinish() {
    }

    protected boolean handleFinishFailure(Status status) {
        StatusDialog.open(this.getContainer().getShell(), status);
        return false;
    }

    public boolean performCancel() {
        return true;
    }

    public final IWizardContainer getContainer() {
        return this.container;
    }

    public final void setContainer(IWizardContainer container) {
        this.container = container;
    }

    public final Image getDefaultPageImage() {
        if (this.defaultPageImage == null) {
            this.defaultPageImage = JFaceResources.getResources().createImageWithDefault(this.defaultPageImageDescriptor);
        }
        return this.defaultPageImage;
    }

    public final RGB getTitleBarColor() {
        return null;
    }

    public final String getWindowTitle() {
        return this.part.getLabel();
    }

    public final IDialogSettings getDialogSettings() {
        return null;
    }

    public final boolean isHelpAvailable() {
        return false;
    }

    public final boolean needsPreviousAndNextButtons() {
        return true;
    }

    public final boolean needsProgressMonitor() {
        return true;
    }

    public final void createPageControls(Composite pageContainer) {
    }

    protected final void openFileEditors(IFile ... files) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null && file.isAccessible()) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    protected final void openFileEditor(IFile file) {
        this.openFileEditor(file, null);
    }

    protected final void openFileEditor(IFile file, String editor) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            try {
                if (editor == null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                } else {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editor);
                    IDE.setDefaultEditor((IFile)file, (String)editor);
                }
            }
            catch (PartInitException e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
    }

    private final void refreshImage() {
        if (this.defaultPageImage != null) {
            JFaceResources.getResources().destroyImage(this.defaultPageImageDescriptor);
            this.defaultPageImage = null;
        }
        this.defaultPageImageDescriptor = SwtUtil.toImageDescriptor(this.part.getImage());
        if (this.defaultPageImageDescriptor == null) {
            this.defaultPageImageDescriptor = JFaceResources.getImageRegistry().getDescriptor("org.eclipse.jface.wizard.Wizard.pageImage");
        }
    }

    private final void refreshTitle() {
        IWizardContainer container = this.getContainer();
        if (container != null) {
            container.updateWindowTitle();
        }
    }

    public void dispose() {
        if (this.element != null) {
            if (this.elementInstantiatedLocally) {
                this.element.dispose();
            }
            this.element = null;
        }
        if (this.part != null) {
            this.part.dispose();
            this.part = null;
        }
        if (this.definition != null) {
            this.definition.dispose();
            this.definition = null;
        }
        if (this.defaultPageImage != null) {
            JFaceResources.getResources().destroyImage(this.defaultPageImageDescriptor);
            this.defaultPageImage = null;
        }
        this.defaultPageImageDescriptor = null;
        this.container = null;
        this.pages = null;
    }
}

