/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class TextCapacityFeedback
extends Composite {
    @Text(value="{0} characters left")
    private static LocalizableText underLimitMessage;
    @Text(value="1 character left")
    private static LocalizableText underLimitByOneMessage;
    @Text(value="No characters left")
    private static LocalizableText atLimitMessage;
    @Text(value="{0} characters over the limit")
    private static LocalizableText overLimitMessage;
    @Text(value="1 character over the limit")
    private static LocalizableText overLimitByOneMessage;
    private final org.eclipse.swt.widgets.Text textField;
    private final int limit;
    private final Label label;
    private final Progress progress;

    static {
        LocalizableText.init(TextCapacityFeedback.class);
    }

    public TextCapacityFeedback(Composite parent, org.eclipse.swt.widgets.Text textField, int limit) {
        super(parent, 0);
        this.textField = textField;
        this.limit = limit;
        this.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        this.label = new Label((Composite)this, 0);
        this.label.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.label.setForeground(this.getDisplay().getSystemColor(16));
        this.progress = new Progress(this);
        this.progress.setLayoutData(GridLayoutUtil.gd());
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextCapacityFeedback.this.refresh();
            }
        });
        this.refresh();
    }

    private void refresh() {
        int p = this.textField.getText().length();
        int r = this.limit - p;
        String progressLabel = r == 0 ? atLimitMessage.text() : (r == 1 ? underLimitByOneMessage.text() : (r == -1 ? overLimitByOneMessage.text() : (r > 1 ? underLimitMessage.format(new Object[]{r}) : overLimitMessage.format(new Object[]{r * -1}))));
        this.label.setText(progressLabel);
        this.progress.progress((double)p / (double)this.limit);
        if (p == 0) {
            this.progress.setVisible(false);
        } else {
            this.progress.progress((double)p / (double)this.limit);
            this.progress.setVisible(true);
        }
    }

    private static final class Progress
    extends Canvas {
        private double progress;

        public Progress(Composite parent) {
            super(parent, 0);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    Progress.this.paint(event);
                }
            });
        }

        public void progress(double progress) {
            this.progress = progress;
            this.redraw();
        }

        public Point computeSize(int wHind, int hHint, boolean changed) {
            return new Point(140, 9);
        }

        private void paint(PaintEvent event) {
            boolean over;
            int r;
            int p;
            GC gc = event.gc;
            if (this.progress > 1.0) {
                p = 138;
                r = 0;
                over = true;
            } else {
                p = (int)(this.progress * 138.0);
                r = 138 - p;
                over = false;
            }
            gc.setForeground(this.getDisplay().getSystemColor(15));
            gc.drawRectangle(0, 0, 139, 8);
            if (p > 0) {
                gc.setBackground(this.getDisplay().getSystemColor(over ? 3 : 15));
                gc.fillRectangle(1, 1, p, 7);
            }
            if (r > 0) {
                gc.setBackground(this.getDisplay().getSystemColor(1));
                gc.fillRectangle(p + 1, 1, r, 7);
            }
        }
    }
}

