/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.textSelectionService;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Transient;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.Unique;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.TextSelectionService;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public final class TextSelectionServiceSample {

    public static final class InsertEnvironmentVariablesActionHandler
    extends SapphireActionHandler {
        protected final Object run(Presentation context) {
            InsertEnvironmentVariablesOp operation = (InsertEnvironmentVariablesOp)InsertEnvironmentVariablesOp.TYPE.instantiate();
            try {
                operation.setContext((PropertyEditorPart)context.part());
                SapphireDialog dialog = new SapphireDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Element)operation, DefinitionLoader.sdef(TextSelectionServiceSample.class).dialog("InsertEnvironmentVariablesDialog"));
                dialog.open();
            }
            finally {
                operation.dispose();
            }
            return null;
        }
    }

    public static interface InsertEnvironmentVariablesOp
    extends ExecutableElement {
        public static final ElementType TYPE = new ElementType(InsertEnvironmentVariablesOp.class);
        @Type(base=PropertyEditorPart.class)
        public static final TransientProperty PROP_CONTEXT = new TransientProperty(TYPE, "Context");
        @Type(base=Variable.class)
        @Service(impl=VariablesPossibleValuesService.class)
        public static final ListProperty PROP_VARIABLES = new ListProperty(TYPE, "Variables");

        public Transient<PropertyEditorPart> getContext();

        public void setContext(PropertyEditorPart var1);

        public ElementList<Variable> getVariables();

        @DelegateImplementation(value=ExecuteMethodDelegate.class)
        public Status execute(ProgressMonitor var1);

        public static class ExecuteMethodDelegate {
            public static Status execute(InsertEnvironmentVariablesOp op, ProgressMonitor monitor) {
                PropertyEditorPart context = (PropertyEditorPart)op.getContext().content();
                Value property = (Value)context.property();
                TextSelectionService textSelectionService = (TextSelectionService)context.service(TextSelectionService.class);
                TextSelectionService.Range initialSelection = textSelectionService.selection();
                String initialText = property.text();
                StringBuilder modifiedText = new StringBuilder();
                if (initialText != null) {
                    modifiedText.append(initialText.substring(0, initialSelection.start()));
                }
                StringBuilder variables = new StringBuilder();
                for (Variable variable : op.getVariables()) {
                    variables.append("${");
                    variables.append(variable.getName().text());
                    variables.append('}');
                }
                modifiedText.append((CharSequence)variables);
                if (initialText != null) {
                    modifiedText.append(initialText.substring(initialSelection.end()));
                }
                property.write((Object)modifiedText.toString());
                textSelectionService.select(initialSelection.start() + variables.length());
                return Status.createOkStatus();
            }
        }

        public static interface Variable
        extends Element {
            public static final ElementType TYPE = new ElementType(Variable.class);
            @Required
            @Unique
            public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");

            public Value<String> getName();

            public void setName(String var1);
        }

        public static class VariablesPossibleValuesService
        extends PossibleValuesService {
            protected void compute(Set<String> values) {
                for (String variable : System.getenv().keySet()) {
                    values.add(variable);
                }
            }
        }
    }

    private static abstract class MoveActionHandler
    extends SapphireActionHandler {
        private PropertyEditorPart part;
        private Value<?> property;
        private TextSelectionService textSelectionService;

        private MoveActionHandler() {
        }

        public final void init(SapphireAction action, ActionHandlerDef def) {
            super.init(action, def);
            this.part = (PropertyEditorPart)action.getPart();
            this.property = (Value)this.part.property();
            this.textSelectionService = (TextSelectionService)this.part.service(TextSelectionService.class);
            this.refreshEnablement();
            final Listener textSelectionServiceListener = new Listener(){

                public void handle(Event event) {
                    MoveActionHandler.this.refreshEnablement();
                }
            };
            this.textSelectionService.attach(textSelectionServiceListener);
            FilteredListener<PropertyContentEvent> propertyContentListener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    MoveActionHandler.this.refreshEnablement();
                }
            };
            this.property.attach((Listener)propertyContentListener);
            this.attach((Listener)new FilteredListener<DisposeEvent>((Listener)propertyContentListener){
                private final /* synthetic */ Listener val$propertyContentListener;
                {
                    this.val$propertyContentListener = listener2;
                }

                protected void handleTypedEvent(DisposeEvent event) {
                    MoveActionHandler.this.textSelectionService.detach(textSelectionServiceListener);
                    MoveActionHandler.this.part.detach(this.val$propertyContentListener);
                }
            });
        }

        private void refreshEnablement() {
            this.refreshEnablement(this.text(), this.textSelectionService.selection());
        }

        protected abstract void refreshEnablement(String var1, TextSelectionService.Range var2);

        protected final Object run(Presentation context) {
            this.run(this.text(), this.textSelectionService);
            return null;
        }

        protected abstract void run(String var1, TextSelectionService var2);

        private String text() {
            String text = this.property.text();
            return text != null ? text : "";
        }
    }

    public static final class MoveLeftActionHandler
    extends MoveActionHandler {
        @Override
        protected void refreshEnablement(String text, TextSelectionService.Range selection) {
            this.setEnabled(selection.end() > 0);
        }

        @Override
        protected void run(String text, TextSelectionService textSelectionService) {
            TextSelectionService.Range selection = textSelectionService.selection();
            if (selection.end() > 0) {
                textSelectionService.select(Math.max(0, selection.start() - 1), selection.end() - 1);
            }
        }
    }

    public static final class MoveRightActionHandler
    extends MoveActionHandler {
        @Override
        protected void refreshEnablement(String text, TextSelectionService.Range selection) {
            this.setEnabled(selection.start() < text.length());
        }

        @Override
        protected void run(String text, TextSelectionService textSelectionService) {
            TextSelectionService.Range selection = textSelectionService.selection();
            if (selection.start() < text.length()) {
                textSelectionService.select(selection.start() + 1, Math.min(selection.end() + 1, text.length()));
            }
        }
    }

    public static final class OpenSampleHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            RootElement element = (RootElement)RootElement.TYPE.instantiate();
            try {
                SapphireDialog dialog = new SapphireDialog(window.getShell(), (Element)element, DefinitionLoader.sdef(TextSelectionServiceSample.class).dialog());
                dialog.open();
            }
            finally {
                element.dispose();
            }
            return null;
        }
    }

    public static final class PropertyEditorListener
    extends Listener {
        private TextSelectionService textSelectionService;
        private Listener textSelectionServiceListener;

        public void handle(Event event) {
            if (event instanceof SapphirePart.PartInitializationEvent) {
                PropertyEditorPart part = (PropertyEditorPart)((SapphirePart.PartInitializationEvent)event).part();
                Property property = part.property();
                final Value textSelectionProperty = (Value)property.element().property(String.valueOf(property.name()) + "Selection");
                this.textSelectionServiceListener = new Listener(){

                    public void handle(Event event) {
                        textSelectionProperty.write((Object)PropertyEditorListener.this.textSelectionService.selection().toString());
                    }
                };
                this.textSelectionService = (TextSelectionService)part.service(TextSelectionService.class);
                this.textSelectionService.attach(this.textSelectionServiceListener);
                this.textSelectionServiceListener.handle(null);
            } else if (event instanceof DisposeEvent) {
                this.textSelectionService.detach(this.textSelectionServiceListener);
            }
        }
    }

    public static interface RootElement
    extends Element {
        public static final ElementType TYPE = new ElementType(RootElement.class);
        public static final ValueProperty PROP_TEXT = new ValueProperty(TYPE, "Text");
        public static final ValueProperty PROP_TEXT_SELECTION = new ValueProperty(TYPE, "TextSelection");

        public Value<String> getText();

        public void setText(String var1);

        public Value<String> getTextSelection();

        public void setTextSelection(String var1);
    }
}

