/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyContentEvent;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.ServiceEvent;

public abstract class ElementReferenceService
extends ReferenceService<Element> {
    private ElementList<?> list;
    private String key;
    private Listener listener;

    public abstract ElementList<?> list();

    public abstract String key();

    @Override
    protected void initReferenceService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                ValuePropertyContentEvent evt;
                Element element;
                if (event instanceof ValuePropertyContentEvent && (element = (evt = (ValuePropertyContentEvent)event).property().element()) == ElementReferenceService.this.target() && evt.refactor()) {
                    ElementReferenceService.this.context(Value.class).write(evt.after());
                }
                ElementReferenceService.this.refresh();
            }
        };
        this.attach(new FilteredListener<SourceEvent>(){

            @Override
            protected void handleTypedEvent(SourceEvent event) {
                ElementReferenceService.this.refresh();
            }
        });
    }

    @Override
    protected final Element compute() {
        Value reference = this.context(Value.class);
        String text = reference.text();
        ElementList<?> list = this.list();
        String key = this.key();
        if (this.list != list || !MiscUtil.equal(this.key, key)) {
            if (this.list != null) {
                this.list.detach(this.listener, this.key);
                this.list = null;
            }
            this.list = list;
            this.key = key;
            if (list != null) {
                this.list.attach(this.listener, this.key);
            }
        }
        if (list != null && text != null) {
            for (Element element : list) {
                String n = ((Value)element.property(this.key)).text();
                if (n == null || !n.equals(text)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.list != null) {
            if (!this.list.disposed()) {
                this.list.detach(this.listener, this.key);
            }
            this.list = null;
        }
        this.key = null;
        this.listener = null;
        super.dispose();
    }

    public final class KeyEvent
    extends SourceEvent {
    }

    public final class ListEvent
    extends SourceEvent {
    }

    public abstract class SourceEvent
    extends ServiceEvent {
        public SourceEvent() {
            super(ElementReferenceService.this);
        }
    }
}

