/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Validations;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.util.ListFactory;

public final class DeclarativeValidationService
extends ValidationService {
    private List<Rule> rules;

    @Override
    protected void initValidationService() {
        Element element = this.context(Element.class);
        PropertyDef property = this.context(PropertyDef.class);
        ListFactory<Validation> annotations = ListFactory.start();
        if (property == null) {
            ElementType type = element.type();
            annotations.add((Collection<Validation>)type.getAnnotations(Validation.class));
            for (Validations validations : type.getAnnotations(Validations.class)) {
                annotations.add(validations.value());
            }
        } else {
            annotations.add((Collection<Validation>)property.getAnnotations(Validation.class));
            for (Validations v : property.getAnnotations(Validations.class)) {
                annotations.add(v.value());
            }
        }
        Listener listener = new Listener(){

            @Override
            public void handle(Event event) {
                DeclarativeValidationService.this.refresh();
            }
        };
        ListFactory<Rule> listFactory = ListFactory.start();
        for (Validation annotation : annotations.result()) {
            if (annotation.severity() == Status.Severity.OK) continue;
            Rule rule = null;
            try {
                rule = new Rule(element, annotation.rule(), annotation.message(), annotation.severity());
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
            if (rule == null) continue;
            rule.attach(listener);
            listFactory.add(rule);
        }
        this.rules = listFactory.result();
    }

    @Override
    protected Status compute() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (Rule rule : this.rules) {
            factory.merge(rule.validation());
        }
        return factory.create();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Rule rule : this.rules) {
            rule.dispose();
        }
        this.rules = null;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef property = context.find(PropertyDef.class);
            if (property == null) {
                ElementType type = context.find(Element.class).type();
                return type.hasAnnotation(Validation.class) || type.hasAnnotation(Validations.class);
            }
            return property.hasAnnotation(Validation.class) || property.hasAnnotation(Validations.class);
        }
    }

    private static final class Rule {
        private final Element element;
        private final FunctionResult ruleFunctionResult;
        private final Function messageFunction;
        private final Status.Severity severity;

        public Rule(Element element, String rule, String message, Status.Severity severity) {
            this.element = element;
            this.severity = severity;
            Function messageFunction = ExpressionLanguageParser.parse(message);
            this.messageFunction = messageFunction = FailSafeFunction.create(messageFunction, String.class, false);
            Function ruleFunction = ExpressionLanguageParser.parse(rule);
            ruleFunction = FailSafeFunction.create(ruleFunction, Boolean.class, false);
            this.ruleFunctionResult = ruleFunction.evaluate(new ModelElementFunctionContext(element));
        }

        public Status validation() {
            if (!((Boolean)this.ruleFunctionResult.value()).booleanValue()) {
                Throwable throwable = null;
                Object var2_3 = null;
                try (FunctionResult messageFunctionResult = this.messageFunction.evaluate(new ModelElementFunctionContext(this.element));){
                    return Status.createStatus(this.severity, (String)messageFunctionResult.value());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return Status.createOkStatus();
        }

        public void attach(Listener listener) {
            this.ruleFunctionResult.attach(listener);
        }

        public void dispose() {
            this.ruleFunctionResult.dispose();
        }
    }
}

