/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.el.TestElement;
import org.junit.Test;

public final class MiscTests
extends SapphireTestCase {
    private void test(String expr, Object expected) {
        this.test(expr, expected, new FunctionContext());
    }

    private void test(String expr, Object expected, FunctionContext context) {
        Object actual = ExpressionLanguageParser.parse((String)expr).evaluate(context).value();
        MiscTests.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void literalNull() {
        this.test("${null}", null);
    }

    private void literalBoolean(String literal) {
        this.test("${" + literal + "}", Boolean.valueOf(literal));
    }

    @Test
    public void literalBoolean1() {
        this.literalBoolean("true");
    }

    @Test
    public void literalBoolean2() {
        this.literalBoolean("false");
    }

    private void literalInteger(String literal) {
        this.test("${" + literal + "}", new BigInteger(literal));
    }

    @Test
    public void literalInteger1() {
        this.literalInteger("1234567");
    }

    @Test
    public void literalInteger2() {
        this.literalInteger("1234567890123456789012345678901234567890");
    }

    private void literalDecimal(String literal) {
        this.test("${" + literal + "}", new BigDecimal(literal));
    }

    @Test
    public void literalDecimal1() {
        this.literalDecimal("12.34567");
    }

    @Test
    public void literalDecimal2() {
        this.literalDecimal(".34567");
    }

    @Test
    public void literalDecimal3() {
        this.literalDecimal("12e23");
    }

    @Test
    public void literalDecimal4() {
        this.literalDecimal("12e+23");
    }

    @Test
    public void literalDecimal5() {
        this.literalDecimal("12e-23");
    }

    @Test
    public void literalDecimal6() {
        this.literalDecimal("12.345e23");
    }

    @Test
    public void literalDecimal7() {
        this.literalDecimal("12.345e+23");
    }

    @Test
    public void literalDecimal8() {
        this.literalDecimal("12.345e-23");
    }

    @Test
    public void literalDecimal9() {
        this.literalDecimal("12E23");
    }

    @Test
    public void literalDecimal10() {
        this.literalDecimal("12E+23");
    }

    @Test
    public void literalDecimal11() {
        this.literalDecimal("12E-23");
    }

    @Test
    public void literalDecimal12() {
        this.literalDecimal("12.345E23");
    }

    @Test
    public void literalDecimal13() {
        this.literalDecimal("12.345E+23");
    }

    @Test
    public void literalDecimal14() {
        this.literalDecimal("12.345E-23");
    }

    @Test
    public void literalString1() {
        this.test("${\"abcdefg 12345 xyz%%\"}", "abcdefg 12345 xyz%%");
    }

    @Test
    public void literalString2() {
        this.test("${'abcdefg 12345 xyz%%'}", "abcdefg 12345 xyz%%");
    }

    @Test
    public void literalString3() {
        this.test("${\"abcdefg \\\"12345\\\" xyz%%\"}", "abcdefg \"12345\" xyz%%");
    }

    @Test
    public void literalString4() {
        this.test("${\"abcdefg '12345' xyz%%\"}", "abcdefg '12345' xyz%%");
    }

    @Test
    public void literalString5() {
        this.test("${'abcdefg \"12345\" xyz%%'}", "abcdefg \"12345\" xyz%%");
    }

    @Test
    public void literalString6() {
        this.test("${'abcdefg \\'12345\\' xyz%%'}", "abcdefg '12345' xyz%%");
    }

    @Test
    public void precedence1() {
        this.test("${3+4*5}", new BigInteger("23"));
    }

    @Test
    public void precedence2() {
        this.test("${(3+4)*5}", new BigInteger("35"));
    }

    @Test
    public void composite1() {
        this.test("abc", "abc");
    }

    @Test
    public void composite2() {
        this.test("abc${'def'}", "abcdef");
    }

    @Test
    public void composite3() {
        this.test("abc${'def'}ghi", "abcdefghi");
    }

    @Test
    public void composite4() {
        this.test("abc${'def'}ghi${'jkl'}", "abcdefghijkl");
    }

    @Test
    public void composite5() {
        this.test("abc${5}ghi${6}", "abc5ghi6");
    }

    @Test
    public void composite6() {
        this.test("abc${3*5}ghi${3>5?6.2:7.3}", "abc15ghi7.3");
    }

    @Test
    public void functions1() {
        this.test("${ test:factorial( 7 ) }", new BigInteger("5040"));
    }

    @Test
    public void functions2() {
        this.test("${ test:factorial( 15 + 5 ) }", new BigInteger("2432902008176640000"));
    }

    @Test
    public void concat1() {
        this.test("${concat('a','b')}", "ab");
    }

    @Test
    public void concat2() {
        this.test("${concat(2010,'-',12,'-',2)}", "2010-12-2");
    }

    @Test
    public void firstSegment1() {
        this.test("${FirstSegment('abc.def.ghi','.')}", "abc");
    }

    @Test
    public void firstSegment2() {
        this.test("${FirstSegment('abc/def\\\\ghi','\\\\/')}", "abc");
    }

    @Test
    public void firstSegment3() {
        this.test("${FirstSegment('abc','.')}", "abc");
    }

    @Test
    public void firstSegment4() {
        this.test("${FirstSegment(null,'.')}", "");
    }

    @Test
    public void lastSegment1() {
        this.test("${LastSegment('abc.def.ghi','.')}", "ghi");
    }

    @Test
    public void lastSegment2() {
        this.test("${LastSegment('abc/def\\\\ghi','\\\\/')}", "ghi");
    }

    @Test
    public void lastSegment3() {
        this.test("${LastSegment('abc','.')}", "abc");
    }

    @Test
    public void lastSegment4() {
        this.test("${LastSegment(null,'.')}", "");
    }

    private void properties(String expr, Object expected) {
        TestElement root = (TestElement)TestElement.TYPE.instantiate();
        TestElement child = (TestElement)root.getFooBar().content(true);
        TestElement grandchild = (TestElement)child.getFooBar().content(true);
        root.setIntegerProp(1);
        root.setStringProp("ABC");
        child.setIntegerProp(2);
        child.setStringProp("DEF");
        grandchild.setIntegerProp(3);
        grandchild.setStringProp("GHI");
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)root);
        this.test(expr, expected, (FunctionContext)context);
    }

    @Test
    public void properties1() {
        this.properties("${ IntegerProp + FooBar.IntegerProp + FooBar.FooBar[ 'IntegerProp' ] }", 6L);
    }

    @Test
    public void properties2() {
        this.properties("${ StringProp }${ FooBar.StringProp }${ FooBar.FooBar[ 'StringProp' ] }", "ABCDEFGHI");
    }
}

