/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0019;

import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.misc.t0019.TestElement;
import org.junit.Test;

public final class ModelElementClearTests
extends SapphireTestCase {
    @Test
    public void testValuePropertyClear() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.setStringValueProperty("abc");
            element.setIntegerValueProperty(123);
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertEquals((Object)123, (Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property(TestElement.PROP_STRING_VALUE_PROPERTY).clear();
            element.property(TestElement.PROP_INTEGER_VALUE_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertNull((Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testTransientPropertyClear() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.setTransientProperty((Object)this);
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)((Object)this), (Object)element.getTransientProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property(TestElement.PROP_TRANSIENT_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getTransientProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testElementPropertyClear() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            ((TestElement.Child)element.getElementProperty().content(true)).setValueProperty("abc");
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)((TestElement.Child)element.getElementProperty().content()).getValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property(TestElement.PROP_ELEMENT_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getElementProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testImpliedElementPropertyClear() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getImpliedElementProperty().setValueProperty("abc");
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
            element.property((ElementProperty)TestElement.PROP_IMPLIED_ELEMENT_PROPERTY).clear();
            ModelElementClearTests.assertNull((Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)1L, (long)element.getListProperty().size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testListPropertyClear() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.getListProperty().insert();
            element.getListProperty().insert();
            element.setStringValueProperty("abc");
            ModelElementClearTests.assertEquals((long)2L, (long)element.getListProperty().size());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
            element.property(TestElement.PROP_LIST_PROPERTY).clear();
            ModelElementClearTests.assertEquals((long)0L, (long)element.getListProperty().size());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testAllPropertiesClear() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement element = (TestElement)TestElement.TYPE.instantiate();){
            element.setStringValueProperty("abc");
            element.setIntegerValueProperty(123);
            element.setTransientProperty((Object)this);
            ((TestElement.Child)element.getElementProperty().content(true)).setValueProperty("abc");
            element.getImpliedElementProperty().setValueProperty("abc");
            element.getListProperty().insert();
            element.getListProperty().insert();
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertEquals((Object)123, (Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertEquals((Object)((Object)this), (Object)element.getTransientProperty().content());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)((TestElement.Child)element.getElementProperty().content()).getValueProperty().content());
            ModelElementClearTests.assertEquals((Object)"abc", (Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)2L, (long)element.getListProperty().size());
            element.clear();
            ModelElementClearTests.assertNull((Object)element.getStringValueProperty().content());
            ModelElementClearTests.assertNull((Object)element.getIntegerValueProperty().content());
            ModelElementClearTests.assertNull((Object)element.getTransientProperty().content());
            ModelElementClearTests.assertNull((Object)element.getElementProperty().content());
            ModelElementClearTests.assertNull((Object)element.getImpliedElementProperty().getValueProperty().content());
            ModelElementClearTests.assertEquals((long)0L, (long)element.getListProperty().size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

