/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.xml.StandardImpliedXmlElementBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlElementBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.StandardXmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public abstract class XmlResource
extends Resource {
    private XmlNamespaceResolver xmlNamespaceResolver;

    public XmlResource(Resource parent) {
        super(parent);
    }

    public void init(Element modelElement) {
        super.init(modelElement);
        this.xmlNamespaceResolver = new StandardXmlNamespaceResolver(modelElement.type());
    }

    public final XmlNamespaceResolver getXmlNamespaceResolver() {
        return this.xmlNamespaceResolver;
    }

    public abstract XmlElement getXmlElement(boolean var1);

    public final XmlElement getXmlElement() {
        return this.getXmlElement(false);
    }

    protected PropertyBinding createBinding(Property property) {
        Object binding = null;
        if (property instanceof Value) {
            CustomXmlValueBinding customBindingAnnotation = (CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class);
            if (customBindingAnnotation != null) {
                try {
                    binding = (PropertyBinding)customBindingAnnotation.impl().newInstance();
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    binding = null;
                }
            } else {
                binding = new StandardXmlValueBindingImpl();
            }
        } else if (property instanceof ElementHandle) {
            CustomXmlElementBinding customBindingAnnotation = (CustomXmlElementBinding)property.definition().getAnnotation(CustomXmlElementBinding.class);
            if (customBindingAnnotation != null) {
                try {
                    binding = (PropertyBinding)customBindingAnnotation.impl().newInstance();
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    binding = null;
                }
            } else {
                binding = property.definition() instanceof ImpliedElementProperty ? new StandardImpliedXmlElementBindingImpl() : new StandardXmlElementBindingImpl();
            }
        } else if (property instanceof ElementList) {
            CustomXmlListBinding customBindingAnnotation = (CustomXmlListBinding)property.definition().getAnnotation(CustomXmlListBinding.class);
            if (customBindingAnnotation != null) {
                try {
                    binding = (PropertyBinding)customBindingAnnotation.impl().newInstance();
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                    binding = null;
                }
            } else {
                binding = new StandardXmlListBindingImpl();
            }
        }
        return binding;
    }
}

