/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElementDefinition
extends XmlContentModel {
    private QName elementName;
    private QName contentModelName;
    private boolean isAbstract;
    private QName substitutionGroup;
    private List<XmlElementDefinition> substitutionList;

    protected XmlElementDefinition(XmlDocumentSchema schema, QName elementName, QName contentModelName, int minOccur, int maxOccur) {
        this(schema, elementName, contentModelName, minOccur, maxOccur, false, null);
    }

    protected XmlElementDefinition(XmlDocumentSchema schema, QName elementName, QName contentModelName, int minOccur, int maxOccur, boolean isAbstract, QName substitutionGroup) {
        super(schema, minOccur, maxOccur);
        this.elementName = elementName;
        this.contentModelName = contentModelName;
        this.isAbstract = isAbstract;
        this.substitutionGroup = substitutionGroup;
    }

    public QName getName() {
        return this.elementName;
    }

    public QName getContentModelName() {
        return this.contentModelName;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public QName getSubstitutionGroup() {
        return this.substitutionGroup;
    }

    public List<XmlElementDefinition> getSubstitutionList() {
        return this.substitutionList;
    }

    public void setSubstitutionList(List<XmlElementDefinition> substitutionList) {
        this.substitutionList = substitutionList;
    }

    public XmlContentModel getContentModel() {
        QName contentModelName = this.getContentModelName();
        if (contentModelName == null) {
            return null;
        }
        String namespace = contentModelName.getNamespaceURI();
        String localName = contentModelName.getLocalPart();
        if (namespace.equals(MiscUtil.normalizeToEmptyString((String)this.schema.getNamespace()))) {
            return this.schema.getContentModel(localName);
        }
        String importedSchemaLocation = this.schema.getSchemaLocation(namespace);
        XmlDocumentSchema importedSchema = XmlDocumentSchemasCache.getSchema(importedSchemaLocation);
        return importedSchema.getContentModel(localName);
    }

    @Override
    public XmlContentModel findChildElementContentModel(QName childElementName) {
        if (this.elementName.equals(childElementName)) {
            return this.getContentModel();
        }
        return null;
    }

    @Override
    protected XmlContentModel.InsertionPosition findInsertionPosition(NodeList nodeList, int nodeListLength, QName qname, XmlContentModel.Position position) {
        int elementsConsumed = 0;
        while (position.listIndex < nodeListLength) {
            Node node = nodeList.item(position.listIndex);
            if (node.getNodeType() != 1) {
                ++position.listIndex;
                continue;
            }
            QName eln = new QName(node.getNamespaceURI(), node.getLocalName());
            if (!this.sameElementName(eln)) break;
            ++elementsConsumed;
            ++position.listIndex;
        }
        XmlContentModel.InsertionPosition result = new XmlContentModel.InsertionPosition();
        if (this.sameElementName(qname)) {
            result.listIndex = position.listIndex;
            int elementCountAfterAdd = elementsConsumed + 1;
            result.grade = this.maxOccur != -1 && elementCountAfterAdd > this.maxOccur ? 1 : (elementCountAfterAdd <= this.minOccur ? 4 : 3);
        }
        return result;
    }

    protected boolean sameElementName(QName qname) {
        return this.elementName.equals(qname);
    }

    @Override
    protected void toString(StringBuilder buf, String indent) {
        buf.append(indent);
        buf.append("element [");
        buf.append(this.minOccur);
        buf.append(':');
        buf.append(this.maxOccur);
        buf.append("]\n");
        buf.append(indent);
        buf.append("{\n");
        buf.append(indent);
        buf.append("    name = ");
        buf.append(this.elementName);
        buf.append('\n');
        QName contentModelName = this.getContentModelName();
        if (contentModelName != null) {
            buf.append(indent);
            buf.append("    type = ");
            buf.append(contentModelName);
            buf.append('\n');
        }
        if (this.isAbstract()) {
            buf.append(indent);
            buf.append("    abstract=\"true\" ");
            buf.append('\n');
        }
        if (this.getSubstitutionGroup() != null) {
            buf.append(indent);
            buf.append("    SubstitutionGroup = ");
            buf.append(this.getSubstitutionGroup());
            buf.append('\n');
        }
        buf.append(indent);
        buf.append('}');
    }

    public static class Factory
    extends XmlContentModel.Factory {
        protected QName elementName;
        private QName contentModelName;
        private boolean isAbstract = false;
        private QName substitutionGroup = null;

        public final QName getName() {
            return this.elementName;
        }

        public final void setName(QName elementName) {
            this.elementName = elementName;
        }

        public final void setName(String elementName) {
            this.elementName = new QName(elementName);
        }

        public QName getContentModelName() {
            return this.contentModelName;
        }

        public void setContentModelName(QName contentModelName) {
            this.contentModelName = contentModelName;
        }

        public void setContentModelName(String contentModelName) {
            this.contentModelName = new QName(contentModelName);
        }

        public final boolean isAbstract() {
            return this.isAbstract;
        }

        public final void setAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
        }

        public final QName getSubstitutionGroup() {
            return this.substitutionGroup;
        }

        public final void setSubstitutionGroup(QName substitutionGroup) {
            this.substitutionGroup = substitutionGroup;
        }

        @Override
        public XmlContentModel create(XmlDocumentSchema schema) {
            return new XmlElementDefinition(schema, this.elementName, this.contentModelName, this.minOccur, this.maxOccur, this.isAbstract, this.substitutionGroup);
        }
    }
}

