/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.samples.calendar.ICalendar;
import org.eclipse.sapphire.samples.calendar.integrated.IEvent;
import org.eclipse.sapphire.samples.calendar.integrated.internal.EventResource;
import org.eclipse.sapphire.samples.contacts.ContactRepository;

public final class CalendarResource
extends Resource {
    private final ICalendar base;
    private final ContactRepository contacts;

    public CalendarResource(ICalendar base, ContactRepository contacts) {
        super(null);
        this.base = base;
        this.contacts = contacts;
        FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                PropertyDef property = event.property().definition();
                org.eclipse.sapphire.samples.calendar.integrated.ICalendar calendar = (org.eclipse.sapphire.samples.calendar.integrated.ICalendar)CalendarResource.this.element();
                if (property == ICalendar.PROP_EVENTS) {
                    calendar.getEvents().refresh();
                }
            }
        };
        this.base.attach((Listener)listener);
    }

    public ICalendar getBase() {
        return this.base;
    }

    public <A> A adapt(Class<A> adapterType) {
        Object res;
        if (adapterType == ContactRepository.class) {
            res = this.contacts;
        } else {
            res = super.adapt(adapterType);
            if (res == null) {
                res = this.base.adapt(adapterType);
            }
        }
        return (A)res;
    }

    protected PropertyBinding createBinding(Property property) {
        if (property.definition() == org.eclipse.sapphire.samples.calendar.integrated.ICalendar.PROP_EVENTS) {
            LayeredListPropertyBinding binding = new LayeredListPropertyBinding(){
                private final ElementList<org.eclipse.sapphire.samples.calendar.IEvent> base;
                {
                    this.base = CalendarResource.this.base.getEvents();
                }

                public ElementType type(Resource resource) {
                    return IEvent.TYPE;
                }

                protected Resource resource(Object obj) {
                    return new EventResource(CalendarResource.this, (org.eclipse.sapphire.samples.calendar.IEvent)obj);
                }

                protected List<?> readUnderlyingList() {
                    return this.base;
                }

                protected Object insertUnderlyingObject(ElementType type, int position) {
                    return this.base.insert(org.eclipse.sapphire.samples.calendar.IEvent.TYPE, position);
                }

                public void move(Resource resource, int position) {
                    this.base.move((Element)((EventResource)resource).getBase(), position);
                }

                public void remove(Resource resource) {
                    this.base.remove((Object)((EventResource)resource).getBase());
                }
            };
            return binding;
        }
        return null;
    }

    public void save() throws ResourceStoreException {
        this.base.resource().save();
        this.contacts.resource().save();
    }
}

