/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.sqlschema;

import org.eclipse.sapphire.Collation;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Type;
import org.eclipse.sapphire.Unique;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.samples.sqlschema.ColumnType;
import org.eclipse.sapphire.samples.sqlschema.internal.PartOfForeignKeyDerivedValueService;
import org.eclipse.sapphire.samples.sqlschema.internal.PartOfPrimaryKeyDerivedValueService;

public interface Column
extends Element {
    public static final ElementType TYPE = new ElementType(Column.class);
    @Label(standard="name")
    @Required
    @Unique
    @Collation(ignoreCaseDifferences="true")
    @XmlBinding(path="name")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Type(base=ColumnType.class)
    @Label(standard="type")
    @Required
    @XmlBinding(path="type")
    public static final ValueProperty PROP_TYPE = new ValueProperty(TYPE, "Type");
    @Type(base=Integer.class)
    @Label(standard="size", full="column size")
    @XmlBinding(path="size")
    @NumericRange(min="1")
    @Enablement(expr="${ Type == 'STRING' }")
    @Required
    public static final ValueProperty PROP_SIZE = new ValueProperty(TYPE, "Size");
    @Type(base=Boolean.class)
    @Derived
    @Service(impl=PartOfPrimaryKeyDerivedValueService.class)
    public static final ValueProperty PROP_PART_OF_PRIMARY_KEY = new ValueProperty(TYPE, "PartOfPrimaryKey");
    @Type(base=Boolean.class)
    @Derived
    @Service(impl=PartOfForeignKeyDerivedValueService.class)
    public static final ValueProperty PROP_PART_OF_FOREIGN_KEY = new ValueProperty(TYPE, "PartOfForeignKey");

    public Value<String> getName();

    public void setName(String var1);

    public Value<ColumnType> getType();

    public void setType(String var1);

    public void setType(ColumnType var1);

    public Value<Integer> getSize();

    public void setSize(String var1);

    public void setSize(Integer var1);

    public Value<Boolean> isPartOfPrimaryKey();

    public Value<Boolean> isPartOfForeignKey();
}

