/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;

public class WorkspaceFileResourceStore
extends ByteArrayResourceStore {
    private final IFile file;
    private long modStamp;

    public WorkspaceFileResourceStore(IFile file) throws ResourceStoreException {
        this.file = file;
        this.modStamp = -1L;
        if (this.file.exists()) {
            this.modStamp = this.file.getModificationStamp();
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (InputStream in = this.file.getContents();){
                    this.setContents(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                throw new ResourceStoreException((Throwable)e);
            }
            catch (IOException e) {
                throw new ResourceStoreException((Throwable)e);
            }
        }
    }

    public IFile getWorkspaceFile() {
        return this.file;
    }

    public File getFile() {
        return this.file.getLocation().toFile();
    }

    public void save() throws ResourceStoreException {
        this.validateSave();
        try {
            byte[] content = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            if (this.file.exists()) {
                this.file.setContents((InputStream)stream, true, false, null);
            } else if (content.length > 0) {
                WorkspaceFileResourceStore.create(this.file.getParent());
                this.file.create((InputStream)stream, true, null);
            }
            this.modStamp = this.file.getModificationStamp();
        }
        catch (CoreException e) {
            throw new ResourceStoreException((Throwable)e);
        }
    }

    public void validateSave() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (!ws.validateEdit(new IFile[]{this.file}, IWorkspace.VALIDATE_PROMPT).isOK()) {
            throw new ValidateEditException();
        }
    }

    public boolean isOutOfDate() {
        return this.modStamp != this.file.getModificationStamp();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkspaceFileResourceStore) {
            return this.file.getLocation().equals((Object)((WorkspaceFileResourceStore)((Object)obj)).getWorkspaceFile().getLocation());
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public static void create(IContainer container) throws CoreException {
        if (!container.exists()) {
            WorkspaceFileResourceStore.create(container.getParent());
            IFolder iFolder = (IFolder)container;
            iFolder.create(true, true, null);
        }
    }
}

