/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.Length;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class LengthFactsServiceForList
extends FactsService {
    @Text(value="Must have at least one")
    public static LocalizableText atLeastOneStatement;
    @Text(value="Must have at least {0} items")
    public static LocalizableText minLengthStatement;
    @Text(value="Must have at most {0} items")
    public static LocalizableText maxLengthStatement;
    private int min;
    private int max;

    static {
        LocalizableText.init(LengthFactsServiceForList.class);
    }

    @Override
    protected void init() {
        PropertyDef property = this.context(PropertyDef.class);
        Length length = property.getAnnotation(Length.class);
        this.min = length.min();
        this.max = length.max();
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        if (this.min == 1) {
            facts.add(atLeastOneStatement.text());
        } else if (this.min > 1) {
            facts.add(minLengthStatement.format(this.min));
        }
        if (this.max < Integer.MAX_VALUE) {
            facts.add(maxLengthStatement.format(this.max));
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ListProperty property = context.find(ListProperty.class);
            if (property != null) {
                Length length = property.getAnnotation(Length.class);
                return length != null && (length.min() > 0 || length.max() < Integer.MAX_VALUE);
            }
            return false;
        }
    }
}

