/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.internal;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.internal.ContextButtonConnectionRequest;
import org.eclipse.sapphire.ui.swt.gef.internal.SapphireConnectionCreationTool;

public class DiagramNodeConnectionCreationTool
extends SapphireConnectionCreationTool {
    private SapphireDiagramEditor diagramEditor;
    private IDiagramConnectionDef connectionDef;

    public void continueConnection(EditPart targetEditPart, SapphireDiagramEditor diagramEditor, IDiagramConnectionDef connectionDef) {
        this.diagramEditor = diagramEditor;
        this.connectionDef = connectionDef;
        this.activate();
        this.setTargetEditPart(targetEditPart);
        this.setConnectionSource(targetEditPart);
        Command command = targetEditPart.getCommand(this.getTargetRequest());
        ((CreateConnectionRequest)this.getTargetRequest()).setSourceEditPart(targetEditPart);
        if (command != null) {
            this.setState(64);
            this.setCurrentCommand(command);
            this.setViewer((EditPartViewer)diagramEditor.getGraphicalViewer());
        }
        if (this.isInState(64)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(command);
        }
    }

    protected boolean handleMove() {
        if (this.isInState(64)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected Request createTargetRequest() {
        ContextButtonConnectionRequest request = new ContextButtonConnectionRequest();
        request.setType(this.getCommandName());
        request.setConnectionDef(this.connectionDef);
        return request;
    }

    protected void updateTargetRequest() {
        this.updateTargetUnderMouse();
        CreateConnectionRequest request = (CreateConnectionRequest)this.getTargetRequest();
        request.setType((Object)this.getCommandName());
        Point absoluteMousePosition = this.diagramEditor.getMouseLocation();
        request.setLocation(absoluteMousePosition);
    }

    protected boolean handleButtonDown(int button) {
        if (button == 3 && this.stateTransition(64, 0x40000000)) {
            this.getDomain().loadDefaultTool();
            return true;
        }
        return super.handleButtonDown(button);
    }
}

