/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.diagram.editor.ShapeFactoryPart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapeFactoryPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ShapeFactoryModel
extends ShapeModel {
    private List<ShapeModel> children;
    private List<ShapeModel> separators;
    private ShapeFactoryPresentation shapeFactoryPresentation;
    public static final String SHAPE_ADD = "SHAPE_ADD";
    public static final String SHAPE_DELETE = "SHAPE_DELETE";
    public static final String SHAPE_REORDER = "SHAPE_REORDER";

    public ShapeFactoryModel(DiagramNodeModel nodeModel, ShapeModel parent, ShapeFactoryPresentation presentation) {
        super(nodeModel, parent, presentation);
        this.shapeFactoryPresentation = presentation;
        this.children = new ArrayList<ShapeModel>();
        if (this.shapeFactoryPresentation.part().visible()) {
            List<ShapePresentation> presentations = this.shapeFactoryPresentation.getChildren();
            int size = presentations.size();
            int i = 0;
            while (i < size) {
                ShapePresentation shapePresentation = presentations.get(i);
                ShapeModel childModel = ShapeModel.ShapeModelFactory.createShapeModel(nodeModel, this, shapePresentation);
                assert (childModel != null);
                this.children.add(childModel);
                ShapeModel separatorModel = this.getSeparatorModel(nodeModel, i);
                if (separatorModel != null && i < size - 1) {
                    this.children.add(separatorModel);
                }
                ++i;
            }
        }
        presentation.init(this);
    }

    private ShapeModel getSeparatorModel(DiagramNodeModel nodeModel, int index) {
        ShapePresentation separatorPresentation = this.shapeFactoryPresentation.getSeparator();
        if (separatorPresentation != null) {
            int size;
            if (this.separators == null) {
                this.separators = new ArrayList<ShapeModel>();
            }
            if (index + 1 > (size = this.separators.size())) {
                int i = size;
                while (i < index + 1) {
                    ShapeModel separatorModel = ShapeModel.ShapeModelFactory.createShapeModel(nodeModel, this, separatorPresentation);
                    this.separators.add(separatorModel);
                    ++i;
                }
            }
            return this.separators.get(index);
        }
        return null;
    }

    public void handleAddShape(ShapePart shapePart) {
        this.refreshChildren();
        this.firePropertyChange(SHAPE_ADD, null, null);
    }

    public void handleDeleteShape(ShapePart shapePart) {
        this.refreshChildren();
        this.firePropertyChange(SHAPE_DELETE, null, null);
    }

    public void handleReorderShapes(ShapeFactoryPart shapeFactory) {
        this.refreshChildren();
        this.firePropertyChange(SHAPE_REORDER, null, null);
    }

    public void refreshChildren() {
        this.shapeFactoryPresentation.refreshChildren();
        ArrayList<ShapeModel> refreshedChildren = new ArrayList<ShapeModel>();
        if (this.shapeFactoryPresentation.part().visible()) {
            List<ShapePresentation> presentations = this.shapeFactoryPresentation.getChildren();
            int size = presentations.size();
            int i = 0;
            while (i < size) {
                ShapePresentation shapePresentation = presentations.get(i);
                ShapeModel childModel = this.getChildShapeModel(shapePresentation);
                if (childModel == null) {
                    childModel = ShapeModel.ShapeModelFactory.createShapeModel(this.getNodeModel(), this, shapePresentation);
                }
                assert (childModel != null);
                refreshedChildren.add(childModel);
                ShapeModel separatorModel = this.getSeparatorModel(this.getNodeModel(), i);
                if (separatorModel != null && i < size - 1) {
                    refreshedChildren.add(separatorModel);
                }
                ++i;
            }
        }
        this.children = refreshedChildren;
    }

    private ShapeModel getChildShapeModel(ShapePresentation shapePresentation) {
        for (ShapeModel model : this.getChildren()) {
            if (model.getShapePresentation().part() != shapePresentation.part()) continue;
            return model;
        }
        return null;
    }

    public List<ShapeModel> getChildren() {
        return this.children;
    }
}

