/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ImagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.commands.DoubleClickNodeCommand;
import org.eclipse.sapphire.ui.swt.gef.connections.SelfConnectionSourceAnchor;
import org.eclipse.sapphire.ui.swt.gef.connections.SelfConnectionTargetAnchor;
import org.eclipse.sapphire.ui.swt.gef.connections.SelfLoopConnectionRouter;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonManager;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.sapphire.ui.swt.gef.internal.DirectEditorManagerFactory;
import org.eclipse.sapphire.ui.swt.gef.model.ContainerShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModelUtil;
import org.eclipse.sapphire.ui.swt.gef.parts.NodeCellEditorLocator;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeUtil;
import org.eclipse.sapphire.ui.swt.gef.policies.DiagramNodeEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.NodeEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.NodeLabelDirectEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.policies.NodeLayoutEditPolicy;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramNodePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.tools.SapphireNodeDragEditPartsTracker;

public class DiagramNodeEditPart
extends ShapeEditPart
implements NodeEditPart {
    public static final String DIRECT_EDIT_REQUEST_PARAM = "TEXTPART";
    private ConnectionAnchor sourceAnchor;
    private ConnectionAnchor targetAnchor;

    public DiagramNodeEditPart(DiagramConfigurationManager configManager) {
        super(configManager);
    }

    @Override
    protected IFigure createFigure() {
        this.getPresentation().render();
        return this.getPresentation().getFigure();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DiagramNodeEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NodeLabelDirectEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new NodeLayoutEditPolicy((DiagramNodeModel)this.getModel()));
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener(this);
            ContextButtonManager contextButtonManager = this.getConfigurationManager().getDiagramEditor().getContextButtonManager();
            contextButtonManager.register((GraphicalEditPart)this);
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            ContextButtonManager contextButtonManager = this.getConfigurationManager().getDiagramEditor().getContextButtonManager();
            contextButtonManager.deRegister((GraphicalEditPart)this);
            this.getCastedModel().removePropertyChangeListener(this);
            ShapePresentation shapePresentation = this.getCastedModel().getShapePresentation();
            shapePresentation.dispose();
            super.deactivate();
        }
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (child == null) {
            return;
        }
        ShapeModel shapeModel = (ShapeModel)childEditPart.getModel();
        ShapePresentation shapePresentation = shapeModel.getShapePresentation();
        ContainerShapePresentation parentPresentation = this.getParentContainer(shapePresentation);
        IFigure parentFigure = parentPresentation.getFigure();
        Object layoutConstraint = ShapeUtil.getLayoutConstraint(shapePresentation, parentPresentation.getLayout());
        int offset = ShapeUtil.getPresentationCount(parentPresentation, shapePresentation);
        parentFigure.add(child, layoutConstraint, index + offset);
        this.refreshNodeBounds();
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (child == null) {
            return;
        }
        ShapeModel shapeModel = (ShapeModel)childEditPart.getModel();
        ContainerShapePresentation parentPresentation = this.getParentContainer(shapeModel.getShapePresentation());
        IFigure parentFigure = parentPresentation.getFigure();
        parentFigure.remove(child);
    }

    protected List<ShapeModel> getModelChildren() {
        ArrayList<ShapeModel> returnedModelChildren = new ArrayList<ShapeModel>();
        DiagramNodeModel nodeModel = (DiagramNodeModel)this.getModel();
        ShapeModel shapeModel = nodeModel.getShapeModel();
        if (shapeModel instanceof ContainerShapeModel) {
            ContainerShapeModel containerModel = (ContainerShapeModel)shapeModel;
            returnedModelChildren.addAll(ShapeModelUtil.collectActiveChildrenRecursively(containerModel));
        }
        return returnedModelChildren;
    }

    @Override
    public SapphirePart getSapphirePart() {
        return this.getCastedModel().getSapphirePart();
    }

    private void performDirectEdit() {
        List<TextPart> textParts = this.getContainedTextParts();
        if (!textParts.isEmpty()) {
            this.performDirectEdit(textParts.get(0));
        }
    }

    private void performDirectEdit(TextPart textPart) {
        TextFigure textFigure;
        if (textPart.isEditable() && (textFigure = (TextFigure)this.getPartFigure((ShapePart)textPart)) != null) {
            DirectEditManager manager = DirectEditorManagerFactory.createDirectEditorManager((GraphicalEditPart)this, textPart, new NodeCellEditorLocator(this.getConfigurationManager(), textFigure), textFigure);
            manager.show();
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (!(request instanceof DirectEditRequest)) {
                this.performDirectEdit();
            }
        } else if (request.getType().equals("open") && request instanceof SelectionRequest) {
            SelectionRequest selRequest = (SelectionRequest)request;
            Point pt = selRequest.getLocation();
            TextPart textPart = this.getTextPart(pt);
            if (textPart != null) {
                this.performDirectEdit(textPart);
            } else {
                ImagePart imagePart = this.getImagePart(pt);
                if (imagePart != null && !imagePart.getAction("Sapphire.DoubleTap").getActiveHandlers().isEmpty()) {
                    this.invokeDoubleTapAction((ShapePart)imagePart);
                } else {
                    DoubleClickNodeCommand cmd = new DoubleClickNodeCommand(this.getCastedModel().getNodePresentation());
                    if (cmd.canExecute()) {
                        cmd.execute();
                    }
                }
            }
        } else {
            super.performRequest(request);
        }
    }

    protected List<DiagramConnectionModel> getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List<DiagramConnectionModel> getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public DiagramNodeModel getCastedModel() {
        return (DiagramNodeModel)this.getModel();
    }

    public DiagramNodePresentation getPresentation() {
        return this.getCastedModel().getNodePresentation();
    }

    protected void refreshVisuals() {
        ShapePresentation shapePresentation = this.getCastedModel().getShapePresentation();
        shapePresentation.refreshVisuals();
        this.refreshNodeBounds();
    }

    private void refreshNodeBounds() {
        Bounds nb = this.getCastedModel().getNodeBounds();
        Dimension minSize = this.getFigure().getMinimumSize();
        Dimension maxSize = this.getFigure().getMaximumSize();
        int width = nb.getWidth();
        int height = nb.getHeight();
        if (width != -1) {
            width = Math.min(width, maxSize.width);
            width = Math.max(width, minSize.width);
        }
        if (height != -1) {
            height = Math.min(height, maxSize.height);
            height = Math.max(height, minSize.height);
        }
        Rectangle bounds = new Rectangle(nb.getX(), nb.getY(), width, height);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }

    private void updateShapeVisibility(ShapePart shapePart) {
        ShapePresentation nodePresentation = this.getCastedModel().getShapePresentation();
        ShapePresentation shapePresentation = ShapeModelUtil.getChildShapePresentation(nodePresentation, shapePart);
        ShapeUtil.updateFigureForShape(shapePresentation, this.getCastedModel().getDiagramModel().getResourceCache(), this.getConfigurationManager());
        this.refresh();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getSource() == connection.getTarget()) {
            return new SelfConnectionSourceAnchor(this.getFigure());
        }
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new ChopboxAnchor(this.getFigure());
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getSource() == connection.getTarget()) {
            ((PolylineConnection)connection.getFigure()).setConnectionRouter((ConnectionRouter)new SelfLoopConnectionRouter());
            return new SelfConnectionTargetAnchor(this.getFigure());
        }
        if (this.targetAnchor == null) {
            this.targetAnchor = new ChopboxAnchor(this.getFigure());
        }
        return this.targetAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.sourceAnchor == null) {
            this.sourceAnchor = new ChopboxAnchor(this.getFigure());
        }
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("SOURCE_CONNECTIONS".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("TARGET_CONNECTIONS".equals(prop)) {
            this.refreshTargetConnections();
        } else if ("NODE_BOUNDS".equals(prop)) {
            this.refreshNodeBounds();
        } else if ("SHAPE_VISIBILITY_UPDATES".equals(prop)) {
            Object obj = evt.getNewValue();
            if (obj instanceof ShapePart) {
                this.updateShapeVisibility((ShapePart)obj);
            }
        } else if ("NODE_START_EDITING".equals(prop)) {
            ShapePart container;
            List textParts;
            if (evt.getNewValue() == null) {
                this.performDirectEdit();
            } else if (evt.getNewValue() instanceof TextPart) {
                this.performDirectEdit((TextPart)evt.getNewValue());
            } else if (evt.getNewValue() instanceof ShapePart && !(textParts = ShapePart.getContainedShapeParts((ShapePart)(container = (ShapePart)evt.getNewValue()), TextPart.class)).isEmpty()) {
                this.performDirectEdit((TextPart)textParts.get(0));
            }
        }
    }

    @Override
    protected List<TextPart> getContainedTextParts() {
        DiagramNodePart nodePart = this.getCastedModel().getModelPart();
        return nodePart.getContainedTextParts();
    }

    @Override
    protected List<ImagePart> getContainedImageParts() {
        DiagramNodePart nodePart = this.getCastedModel().getModelPart();
        return nodePart.getContainedImageParts();
    }

    public DragTracker getDragTracker(Request request) {
        return new SapphireNodeDragEditPartsTracker((EditPart)this);
    }
}

