/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

public final class ParsedPhoneNumber {
    private String areaCode = null;
    private String localNumber = null;

    public ParsedPhoneNumber(String phoneNumber) {
        int closingParen;
        if (phoneNumber != null && phoneNumber.startsWith("(") && (closingParen = phoneNumber.indexOf(41)) != -1) {
            this.areaCode = phoneNumber.substring(1, closingParen);
            if (closingParen + 1 < phoneNumber.length()) {
                this.localNumber = phoneNumber.substring(closingParen + 1).trim();
            }
        }
        if (this.areaCode == null) {
            this.localNumber = phoneNumber;
        }
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getLocalNumber() {
        return this.localNumber;
    }

    public void setLocalNumber(String localNumber) {
        this.localNumber = localNumber;
    }

    public String toString() {
        if (this.areaCode == null && this.localNumber == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (this.areaCode != null && this.areaCode.length() > 0) {
            buf.append('(');
            buf.append(this.areaCode);
            buf.append(')');
        }
        if (this.localNumber != null) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.localNumber);
        }
        return buf.toString();
    }
}

