/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.element;

import java.util.ArrayList;
import org.eclipse.sapphire.ElementData;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Suspension;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.element.CopyTestElementChild;
import org.eclipse.sapphire.tests.element.CopyTestElementChildEx;
import org.eclipse.sapphire.tests.element.CopyTestElementRoot;
import org.eclipse.sapphire.tests.element.TestElement;
import org.junit.Test;

public final class ElementTests
extends SapphireTestCase {
    @Test
    public void HoldsElement() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement a = (TestElement)TestElement.TYPE.instantiate();){
            TestElement aa = (TestElement)a.getElement().content(true);
            ElementTests.assertTrue((boolean)a.holds(aa));
            ElementTests.assertFalse((boolean)aa.holds(a));
            TestElement aaa = (TestElement)aa.getList().insert();
            ElementTests.assertTrue((boolean)a.holds(aaa));
            ElementTests.assertTrue((boolean)aa.holds(aaa));
            ElementTests.assertFalse((boolean)aaa.holds(a));
            ElementTests.assertFalse((boolean)aaa.holds(aa));
            TestElement ab = (TestElement)a.getList().insert();
            ElementTests.assertTrue((boolean)a.holds(ab));
            ElementTests.assertFalse((boolean)aa.holds(ab));
            ElementTests.assertFalse((boolean)ab.holds(aa));
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (TestElement b = (TestElement)TestElement.TYPE.instantiate();){
                ElementTests.assertFalse((boolean)a.holds(b));
                ElementTests.assertFalse((boolean)b.holds(a));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void HoldsProperty() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TestElement a = (TestElement)TestElement.TYPE.instantiate();){
            ElementTests.assertTrue((boolean)a.holds((Property)a.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)a.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)a.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)a.getList()));
            TestElement aa = (TestElement)a.getElement().content(true);
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getList()));
            TestElement aaa = (TestElement)aa.getList().insert();
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getList()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getValue()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getTransient()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getElement()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getList()));
            TestElement ab = (TestElement)a.getList().insert();
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getList()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getValue()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getTransient()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getElement()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getList()));
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (TestElement b = (TestElement)TestElement.TYPE.instantiate();){
                ElementTests.assertFalse((boolean)a.holds((Property)b.getValue()));
                ElementTests.assertFalse((boolean)b.holds((Property)a.getValue()));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void Suspend() {
        EventLog log = new EventLog();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TestElement a = (TestElement)TestElement.TYPE.instantiate();){
            a.attach(log, "*");
            TestElement aa = (TestElement)a.getElement().content(true);
            aa.setValue("abc");
            aa.getList().insert();
            ElementTests.assertEquals((long)3L, (long)log.size());
            ElementTests.assertPropertyContentEvent(log.event(0), a.getElement());
            ElementTests.assertPropertyContentEvent(log.event(1), aa.getValue());
            ElementTests.assertPropertyContentEvent(log.event(2), aa.getList());
            log.clear();
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (Suspension suspension = aa.suspend();){
                aa.setValue("def");
                ((TestElement)aa.getList().insert()).setValue("ghi");
                ((TestElement)aa.getElement().content(true)).setValue("klm");
                ElementTests.assertEquals((long)0L, (long)log.size());
                a.setValue("nop");
                ElementTests.assertEquals((long)1L, (long)log.size());
                ElementTests.assertPropertyContentEvent(log.event(0), a.getValue());
                log.clear();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            ElementTests.assertEquals((long)5L, (long)log.size());
            ElementTests.assertPropertyContentEvent(log.event(0), aa.getValue());
            ElementTests.assertPropertyContentEvent(log.event(1), aa.getList());
            ElementTests.assertPropertyContentEvent(log.event(2), ((TestElement)aa.getList().get(1)).getValue());
            ElementTests.assertPropertyContentEvent(log.event(3), aa.getElement());
            ElementTests.assertPropertyContentEvent(log.event(4), ((TestElement)aa.getElement().content()).getValue());
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Test
    public void CopyElement() throws Exception {
        CopyTestElementRoot a = (CopyTestElementRoot)CopyTestElementRoot.TYPE.instantiate();
        a.setValueProperty1("abc");
        a.setValueProperty2(5);
        a.setValueProperty3((String)null);
        CopyTestElementChild ac1 = a.getImpliedElementProperty1();
        ac1.setValueProperty1("implied-1");
        CopyTestElementChildEx ac2 = a.getImpliedElementProperty2();
        ac2.setValueProperty1("implied-2-a");
        ac2.setValueProperty2("implied-2-b");
        ac1 = (CopyTestElementChild)a.getElementProperty1().content(true);
        ac1.setValueProperty1("element-1");
        ac2 = (CopyTestElementChildEx)a.getElementProperty2().content(true, CopyTestElementChildEx.TYPE);
        ac2.setValueProperty1("element-2-a");
        ac2.setValueProperty2("element-2-b");
        ac1 = (CopyTestElementChild)a.getListProperty1().insert();
        ac1.setValueProperty1("list-1-a");
        ac1 = (CopyTestElementChild)a.getListProperty1().insert();
        ac1.setValueProperty1("list-1-b");
        ac1 = (CopyTestElementChild)a.getListProperty1().insert();
        ac1.setValueProperty1("list-1-c");
        ac1 = (CopyTestElementChild)a.getListProperty2().insert(CopyTestElementChild.TYPE);
        ac1.setValueProperty1("list-2-a");
        ac2 = (CopyTestElementChildEx)a.getListProperty2().insert(CopyTestElementChildEx.TYPE);
        ac2.setValueProperty1("list-2-b-a");
        ac2.setValueProperty2("list-2-b-b");
        ac2 = (CopyTestElementChildEx)a.getListProperty2().insert(CopyTestElementChildEx.TYPE);
        ac2.setValueProperty1("list-2-c-a");
        ac2.setValueProperty2("list-2-c-b");
        Object t = new Object();
        a.setTransientProperty(t);
        CopyTestElementRoot b = (CopyTestElementRoot)CopyTestElementRoot.TYPE.instantiate();
        b.copy(a);
        ElementTests.assertEquals((Object)b.getValueProperty1().text(false), (Object)"abc");
        ElementTests.assertEquals((Object)b.getValueProperty2().text(false), (Object)"5");
        ElementTests.assertEquals((Object)b.getValueProperty3().text(false), null);
        ElementTests.assertEquals((Object)b.getImpliedElementProperty1().getValueProperty1().text(false), (Object)"implied-1");
        ElementTests.assertEquals((Object)b.getImpliedElementProperty2().getValueProperty1().text(false), (Object)"implied-2-a");
        ElementTests.assertEquals((Object)b.getImpliedElementProperty2().getValueProperty2().text(false), (Object)"implied-2-b");
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getElementProperty1().content()).getValueProperty1().text(false), (Object)"element-1");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getElementProperty2().content()).getValueProperty1().text(false), (Object)"element-2-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getElementProperty2().content()).getValueProperty2().text(false), (Object)"element-2-b");
        ElementTests.assertEquals((long)b.getListProperty1().size(), (long)3L);
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty1().get(0)).getValueProperty1().text(false), (Object)"list-1-a");
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty1().get(1)).getValueProperty1().text(false), (Object)"list-1-b");
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty1().get(2)).getValueProperty1().text(false), (Object)"list-1-c");
        ElementTests.assertEquals((long)b.getListProperty2().size(), (long)3L);
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty2().get(0)).getValueProperty1().text(false), (Object)"list-2-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(1)).getValueProperty1().text(false), (Object)"list-2-b-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(1)).getValueProperty2().text(false), (Object)"list-2-b-b");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(2)).getValueProperty1().text(false), (Object)"list-2-c-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(2)).getValueProperty2().text(false), (Object)"list-2-c-b");
        ElementTests.assertEquals((Object)b.getTransientProperty().content(), (Object)t);
    }

    @Test
    public void CopyElementData() throws Exception {
        ElementData a = new ElementData(CopyTestElementRoot.TYPE);
        a.write("ValueProperty1", (Object)"abc");
        a.write("ValueProperty2", (Object)5);
        a.write("ValueProperty3", null);
        ElementData ac1 = new ElementData(CopyTestElementChild.TYPE);
        a.write("ImpliedElementProperty1", (Object)ac1);
        ac1.write("ValueProperty1", (Object)"implied-1");
        ElementData ac2 = new ElementData(CopyTestElementChildEx.TYPE);
        a.write("ImpliedElementProperty2", (Object)ac2);
        ac2.write("ValueProperty1", (Object)"implied-2-a");
        ac2.write("ValueProperty2", (Object)"implied-2-b");
        ac1 = new ElementData(CopyTestElementChild.TYPE);
        a.write("ElementProperty1", (Object)ac1);
        ac1.write("ValueProperty1", (Object)"element-1");
        ac2 = new ElementData(CopyTestElementChildEx.TYPE);
        a.write("ElementProperty2", (Object)ac2);
        ac2.write("ValueProperty1", (Object)"element-2-a");
        ac2.write("ValueProperty2", (Object)"element-2-b");
        ArrayList<ElementData> list = new ArrayList<ElementData>();
        a.write("ListProperty1", list);
        ac1 = new ElementData(CopyTestElementChild.TYPE);
        list.add(ac1);
        ac1.write("ValueProperty1", (Object)"list-1-a");
        ac1 = new ElementData(CopyTestElementChild.TYPE);
        list.add(ac1);
        ac1.write("ValueProperty1", (Object)"list-1-b");
        ac1 = new ElementData(CopyTestElementChild.TYPE);
        list.add(ac1);
        ac1.write("ValueProperty1", (Object)"list-1-c");
        list = new ArrayList();
        a.write("ListProperty2", list);
        ac1 = new ElementData(CopyTestElementChild.TYPE);
        list.add(ac1);
        ac1.write("ValueProperty1", (Object)"list-2-a");
        ac2 = new ElementData(CopyTestElementChildEx.TYPE);
        list.add(ac2);
        ac2.write("ValueProperty1", (Object)"list-2-b-a");
        ac2.write("ValueProperty2", (Object)"list-2-b-b");
        ac2 = new ElementData(CopyTestElementChildEx.TYPE);
        list.add(ac2);
        ac2.write("ValueProperty1", (Object)"list-2-c-a");
        ac2.write("ValueProperty2", (Object)"list-2-c-b");
        Object t = new Object();
        a.write("TransientProperty", t);
        CopyTestElementRoot b = (CopyTestElementRoot)CopyTestElementRoot.TYPE.instantiate();
        b.copy(a);
        ElementTests.assertEquals((Object)b.getValueProperty1().text(false), (Object)"abc");
        ElementTests.assertEquals((Object)b.getValueProperty2().text(false), (Object)"5");
        ElementTests.assertEquals((Object)b.getValueProperty3().text(false), null);
        ElementTests.assertEquals((Object)b.getImpliedElementProperty1().getValueProperty1().text(false), (Object)"implied-1");
        ElementTests.assertEquals((Object)b.getImpliedElementProperty2().getValueProperty1().text(false), (Object)"implied-2-a");
        ElementTests.assertEquals((Object)b.getImpliedElementProperty2().getValueProperty2().text(false), (Object)"implied-2-b");
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getElementProperty1().content()).getValueProperty1().text(false), (Object)"element-1");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getElementProperty2().content()).getValueProperty1().text(false), (Object)"element-2-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getElementProperty2().content()).getValueProperty2().text(false), (Object)"element-2-b");
        ElementTests.assertEquals((long)b.getListProperty1().size(), (long)3L);
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty1().get(0)).getValueProperty1().text(false), (Object)"list-1-a");
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty1().get(1)).getValueProperty1().text(false), (Object)"list-1-b");
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty1().get(2)).getValueProperty1().text(false), (Object)"list-1-c");
        ElementTests.assertEquals((long)b.getListProperty2().size(), (long)3L);
        ElementTests.assertEquals((Object)((CopyTestElementChild)b.getListProperty2().get(0)).getValueProperty1().text(false), (Object)"list-2-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(1)).getValueProperty1().text(false), (Object)"list-2-b-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(1)).getValueProperty2().text(false), (Object)"list-2-b-b");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(2)).getValueProperty1().text(false), (Object)"list-2-c-a");
        ElementTests.assertEquals((Object)((CopyTestElementChildEx)b.getListProperty2().get(2)).getValueProperty2().text(false), (Object)"list-2-c-b");
        ElementTests.assertEquals((Object)b.getTransientProperty().content(), (Object)t);
    }
}

