/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.dtd.t0003;

import java.nio.charset.StandardCharsets;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.dtd.t0003.TestElement;
import org.eclipse.sapphire.tests.modeling.xml.dtd.t0003.TestElementChild;
import org.eclipse.sapphire.tests.modeling.xml.dtd.t0003.TestElementError1;
import org.eclipse.sapphire.tests.modeling.xml.dtd.t0003.TestElementPublic;
import org.eclipse.sapphire.tests.modeling.xml.dtd.t0003.TestElementSystem;
import org.junit.Test;

public final class TestXmlDtd0003
extends SapphireTestCase {
    @Test
    public void testPublic() throws Exception {
        this.test(TestElementPublic.TYPE, "ExpectedPublic.txt");
    }

    @Test
    public void testSystem() throws Exception {
        this.test(TestElementSystem.TYPE, "ExpectedSystem.txt");
    }

    @Test
    public void testError1() throws Exception {
        this.test(TestElementError1.TYPE, "ExpectedError1.txt");
    }

    @Test
    public void testError2() throws Exception {
        this.test(TestElementError1.TYPE, "ExpectedError2.txt");
    }

    private void test(ElementType type, String expected) throws Exception {
        ByteArrayResourceStore byteArrayResourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(byteArrayResourceStore);
        TestElement root = (TestElement)type.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        ((TestElementChild)root.getCcc().insert()).setText("111");
        ((TestElementChild)root.getBbb().insert()).setText("222");
        ((TestElementChild)root.getAaa().insert()).setText("333");
        ((TestElementChild)root.getCcc().insert()).setText("444");
        ((TestElementChild)root.getBbb().insert()).setText("555");
        ((TestElementChild)root.getAaa().insert()).setText("666");
        root.resource().save();
        String result = new String(byteArrayResourceStore.getContents(), StandardCharsets.UTF_8);
        TestXmlDtd0003.assertEqualsIgnoreNewLineDiffs(this.loadResource(expected), result);
    }
}

