/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.ValuePropertyEditorPresentation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class CheckBoxPropertyEditorPresentation
extends ValuePropertyEditorPresentation {
    private Button checkbox;

    public CheckBoxPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    protected void createContents(Composite parent) {
        final PropertyEditorPart part = this.part();
        String checkboxLayoutHint = part.definition().getHint("checkbox.layout");
        final CheckboxLayout checkboxLayout = checkboxLayoutHint == null ? CheckboxLayout.TRAILING_LABEL : (checkboxLayoutHint.equalsIgnoreCase("leading.label") ? CheckboxLayout.LEADING_LABEL : (checkboxLayoutHint.equalsIgnoreCase("trailing.label") ? CheckboxLayout.TRAILING_LABEL : (checkboxLayoutHint.equalsIgnoreCase("trailing.label.idented") ? CheckboxLayout.TRAILING_LABEL_INDENTED : CheckboxLayout.TRAILING_LABEL)));
        Composite composite = this.createMainComposite(parent, new PropertyEditorPresentation.CreateMainCompositeDelegate(this, part){

            @Override
            public boolean getShowLabel() {
                if (checkboxLayout == CheckboxLayout.TRAILING_LABEL || checkboxLayout == CheckboxLayout.TRAILING_LABEL_INDENTED) {
                    return false;
                }
                return super.getShowLabel();
            }

            @Override
            public boolean getSpanBothColumns() {
                if (checkboxLayout == CheckboxLayout.TRAILING_LABEL) {
                    return true;
                }
                return super.getSpanBothColumns();
            }
        });
        boolean isDeprecated = this.property().definition().hasAnnotation(Deprecated.class);
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(isDeprecated ? 3 : 2, 0, 0), 2));
        PropertyEditorAssistDecorator decorator = this.createDecorator(composite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
        this.checkbox = new Button(composite, 32);
        this.checkbox.setLayoutData((Object)GridLayoutUtil.gd());
        if (checkboxLayout != CheckboxLayout.LEADING_LABEL) {
            final Runnable updateLabelOp = new Runnable(){

                @Override
                public void run() {
                    CheckBoxPropertyEditorPresentation.this.checkbox.setText(part.label(CapitalizationType.FIRST_WORD_ONLY, true));
                }
            };
            this.attachPartListener((Listener)new FilteredListener<SapphirePart.LabelChangedEvent>(){

                protected void handleTypedEvent(SapphirePart.LabelChangedEvent event) {
                    updateLabelOp.run();
                    CheckBoxPropertyEditorPresentation.this.layout();
                }
            });
            updateLabelOp.run();
        }
        if (isDeprecated) {
            Control deprecationMarker = this.createDeprecationMarker(composite);
            deprecationMarker.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhfill(), 3));
        }
        this.attachAccessibleName((Control)this.checkbox);
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean value = CheckBoxPropertyEditorPresentation.this.checkbox.getSelection();
                CheckBoxPropertyEditorPresentation.this.setPropertyValue(String.valueOf(value));
            }
        });
        decorator.addEditorControl((Control)composite);
        this.addControl((Control)this.checkbox);
    }

    @Override
    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        if (!this.checkbox.isDisposed()) {
            Value<?> value = this.property();
            if (value != null) {
                boolean newSimpleValue;
                boolean existingValue = this.checkbox.getSelection();
                if (value.text(false) != null && value.content(false) == null) {
                    newSimpleValue = false;
                } else {
                    Boolean newValue = (Boolean)value.content(true);
                    boolean bl = newSimpleValue = newValue != null ? newValue : false;
                }
                if (newSimpleValue != existingValue) {
                    this.checkbox.setSelection(newSimpleValue);
                }
            } else {
                this.checkbox.setSelection(false);
            }
        }
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.checkbox.setFocus();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.checkbox = null;
    }

    private static enum CheckboxLayout {
        LEADING_LABEL,
        TRAILING_LABEL,
        TRAILING_LABEL_INDENTED;

    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            PropertyDef property = part.property().definition();
            if (property instanceof ValueProperty && property.isOfType(Boolean.class)) {
                return new CheckBoxPropertyEditorPresentation(part, parent, composite);
            }
            return null;
        }
    }
}

